/*
 * Decompiled with CFR 0.152.
 */
package cn.tbox.sdk.model.message;

import cn.tbox.sdk.core.exception.TboxServerException;
import cn.tbox.sdk.core.http.HttpResponseEvent;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageParser {
    private static final Logger logger = LoggerFactory.getLogger((String)"tbox.client");
    private final Map<String, Map<String, Object>> answersHolder = new HashMap<String, Map<String, Object>>();

    public boolean needParse(HttpResponseEvent responseEvent) {
        return "message".equals(responseEvent.getEvent()) || "error".equals(responseEvent.getEvent());
    }

    public Map<String, Object> parse(HttpResponseEvent responseEvent) throws TboxServerException {
        if ("error".equals(responseEvent.getEvent())) {
            this.parseError(responseEvent);
            return new HashMap<String, Object>();
        }
        if ("message".equals(responseEvent.getEvent())) {
            try {
                String type;
                JSONObject data = JSON.parseObject((String)responseEvent.getData());
                switch (type = data.getString("type")) {
                    case "meta": {
                        return this.parseMetaMessage(data);
                    }
                    case "header": {
                        return this.parseHeaderMessage(data);
                    }
                    case "chunk": {
                        return this.parseChunkMessage(data);
                    }
                    case "revoke": {
                        return this.parseRevokeMessage(data);
                    }
                    case "error": {
                        return this.parseErrorMessage(data);
                    }
                    case "charge": {
                        return this.parseChargeMessage(data);
                    }
                    case "end": {
                        return this.parseEndMessage(data);
                    }
                    case "unknown": {
                        return this.parseUnknownMessage(data);
                    }
                    case "followup": {
                        return this.parseFollowupMessage(data);
                    }
                }
                return this.convertJsonNodeToMap(data);
            }
            catch (JSONException e) {
                logger.error("Failed to parse response data", (Throwable)e);
                HashMap<String, Object> errorResult = new HashMap<String, Object>();
                errorResult.put("error", "Failed to parse response data: " + e.getMessage());
                return errorResult;
            }
        }
        try {
            return (Map)JSON.parseObject((String)responseEvent.getData(), HashMap.class);
        }
        catch (JSONException e) {
            logger.error("Failed to parse response data", (Throwable)e);
            HashMap<String, Object> errorResult = new HashMap<String, Object>();
            errorResult.put("error", "Failed to parse response data: " + e.getMessage());
            return errorResult;
        }
    }

    private Map<String, Object> parseChunkMessage(JSONObject data) {
        String lane = data.getString("lane");
        if (lane == null) {
            lane = "default";
        }
        Map<String, Object> result = this.convertJsonNodeToMap(data);
        JSONObject payloadNode = data.getJSONObject("payload");
        String payloadText = payloadNode != null ? payloadNode.toJSONString(new JSONWriter.Feature[0]) : "{}";
        try {
            JSONObject payload = JSON.parseObject((String)payloadText);
            result.put("payload", this.convertJsonNodeToMap(payload));
            if (this.answersHolder.containsKey(lane)) {
                String mediaType = (String)this.answersHolder.get(lane).get("type");
                if ("text".equals(mediaType)) {
                    Map payloadMap = (Map)result.get("payload");
                    String text = payloadMap.getOrDefault("text", "");
                    String currentData = (String)this.answersHolder.get(lane).get("data");
                    this.answersHolder.get(lane).put("data", currentData + text);
                }
                List messages = (List)this.answersHolder.get(lane).get("messages");
                messages.add(result);
            }
        }
        catch (JSONException e) {
            logger.error("Failed to parse payload", (Throwable)e);
        }
        return result;
    }

    private Map<String, Object> parseMetaMessage(JSONObject data) {
        return this.convertJsonNodeToMap(data);
    }

    private Map<String, Object> parseHeaderMessage(JSONObject data) {
        JSONObject payloadNode;
        Map<String, Object> result = this.convertJsonNodeToMap(data);
        String lane = data.getString("lane");
        if (lane == null) {
            lane = "default";
        }
        String payloadText = (payloadNode = data.getJSONObject("payload")) != null ? payloadNode.toJSONString(new JSONWriter.Feature[0]) : "{}";
        try {
            JSONObject payload = JSON.parseObject((String)payloadText);
            result.put("payload", this.convertJsonNodeToMap(payload));
            Map<String, Object> payloadMap = this.convertJsonNodeToMap(payload);
            String mediaType = (String)payloadMap.get("mediaType");
            if (!this.answersHolder.containsKey(lane)) {
                HashMap<String, Object> laneData = new HashMap<String, Object>();
                laneData.put("type", mediaType);
                laneData.put("header", result);
                laneData.put("data", "");
                laneData.put("messages", new ArrayList());
                this.answersHolder.put(lane, laneData);
            } else {
                this.answersHolder.get(lane).put("header", result);
                this.answersHolder.get(lane).put("type", mediaType);
            }
        }
        catch (JSONException e) {
            logger.error("Failed to parse payload", (Throwable)e);
        }
        return result;
    }

    private Map<String, Object> parseRevokeMessage(JSONObject data) {
        return this.convertJsonNodeToMap(data);
    }

    private Map<String, Object> parseErrorMessage(JSONObject data) {
        return this.convertJsonNodeToMap(data);
    }

    private Map<String, Object> parseChargeMessage(JSONObject data) {
        return this.convertJsonNodeToMap(data);
    }

    private Map<String, Object> parseEndMessage(JSONObject data) {
        return this.convertJsonNodeToMap(data);
    }

    private Map<String, Object> parseUnknownMessage(JSONObject data) {
        return this.convertJsonNodeToMap(data);
    }

    private Map<String, Object> parseFollowupMessage(JSONObject data) {
        return this.convertJsonNodeToMap(data);
    }

    private void parseError(HttpResponseEvent responseEvent) throws TboxServerException {
        try {
            JSONObject errorContext = JSON.parseObject((String)responseEvent.getData());
            String message = "unknown error";
            if (errorContext.containsKey("payload")) {
                JSONObject payload = errorContext.getJSONObject("payload");
                if (payload != null && (message = payload.getString("errorMsg")) == null) {
                    message = "unknown error";
                }
            } else if (errorContext.containsKey("errorMsg") && (message = errorContext.getString("errorMsg")) == null) {
                message = "unknown error";
            }
            TboxServerException exception = new TboxServerException(message);
            exception.setErrorContext((Map<String, Object>)errorContext);
            throw exception;
        }
        catch (JSONException e) {
            throw new TboxServerException("Error parsing server error response", e);
        }
    }

    public Map<String, Map<String, Object>> getAnswersHolder() {
        return this.answersHolder;
    }

    private Map<String, Object> convertJsonNodeToMap(JSONObject node) {
        try {
            return (Map)JSON.parseObject((String)node.toJSONString(new JSONWriter.Feature[0]), HashMap.class);
        }
        catch (Exception e) {
            logger.error("Error converting JSONObject to Map", (Throwable)e);
            return new HashMap<String, Object>();
        }
    }
}

