package cn.tbox.sdk.example;

import cn.tbox.sdk.TboxClient;
import cn.tbox.sdk.core.http.HttpClientConfig;
import cn.tbox.sdk.core.exception.TboxClientConfigException;

import java.util.HashMap;
import java.util.Map;

/**
 * Example demonstrating the use of TboxClient.
 */
public class TboxExample {

    /**
     * Main method with examples.
     *
     * @param args Command line arguments (not used)
     */
    public static void main(String[] args) {
        try {
            // Create a client with just authorization token
            TboxClient client = new TboxClient("your-authorization-token-here");
            
            // Example 1: Simple synchronous chat
            System.out.println("Example 1: Simple synchronous chat");
            Map<String, Map<String, Object>> chatResult = client.chatSync(
                    "your-app-id-here",
                    "Hello, how are you?",
                    null
            );
            
            printResult(chatResult);
            
            // Example 2: Streaming chat with conversation ID
            System.out.println("\nExample 2: Streaming chat with conversation ID");
            String conversationId = "conversation-123";
            
            Iterable<Map<String, Object>> chatStream = client.chat(
                    "your-app-id-here",
                    "Tell me more about Java programming",
                    conversationId
            );
            
            for (Map<String, Object> response : chatStream) {
                System.out.println("Received chunk: " + response);
            }
            
            // Example 3: Completion with custom inputs
            System.out.println("\nExample 3: Completion with custom inputs");
            Map<String, Object> inputs = new HashMap<>();
            inputs.put("prompt", "Generate a Java function to calculate factorial");
            
            Map<String, Map<String, Object>> completionResult = client.completionSync(
                    "your-app-id-here",
                    inputs,
                    conversationId
            );
            
            printResult(completionResult);
            
            // Example 4: Advanced client configuration
            System.out.println("\nExample 4: Advanced client configuration");
            HttpClientConfig config = new HttpClientConfig(
                    "your-authorization-token-here",
                    "https",
                    "custom-host.example.com"
            );
            
            TboxClient advancedClient = new TboxClient(config);
            
            // You can then use advancedClient just like the regular client
            
        } catch (TboxClientConfigException e) {
            System.err.println("Configuration error: " + e.getMessage());
            e.printStackTrace();
        }
    }
    
    /**
     * Helper method to print results.
     *
     * @param result Result map to print
     */
    private static void printResult(Map<String, Map<String, Object>> result) {
        for (Map.Entry<String, Map<String, Object>> entry : result.entrySet()) {
            String lane = entry.getKey();
            Map<String, Object> laneData = entry.getValue();
            
            System.out.println("Lane: " + lane);
            System.out.println("Type: " + laneData.get("type"));
            System.out.println("Data: " + laneData.get("data"));
        }
    }
} 