/*
 * Decompiled with CFR 0.152.
 */
package cn.tbox.sdk.core.http;

import cn.tbox.sdk.core.exception.TboxClientConfigException;
import cn.tbox.sdk.core.exception.TboxHttpResponseException;
import cn.tbox.sdk.core.http.HttpClientConfig;
import cn.tbox.sdk.core.http.HttpResponseEvent;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger logger = LoggerFactory.getLogger((String)"tbox.client");
    private static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private static final OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(Duration.ofSeconds(30L)).readTimeout(Duration.ofSeconds(120L)).writeTimeout(Duration.ofSeconds(60L)).build();
    private final HttpClientConfig httpClientConfig;

    public HttpClient(HttpClientConfig httpClientConfig) throws TboxClientConfigException {
        if (httpClientConfig == null) {
            throw new TboxClientConfigException("httpClientConfig is null");
        }
        this.httpClientConfig = httpClientConfig;
    }

    public String post(String path, Map<String, Object> data, Map<String, String> headers) throws TboxClientConfigException, TboxHttpResponseException {
        String string;
        block10: {
            String url = this.buildUrl(path);
            String json = JSON.toJSONString(data);
            RequestBody body = RequestBody.create((String)json, (MediaType)JSON_MEDIA_TYPE);
            Request request = new Request.Builder().url(url).headers(Headers.of(this.generateHeaders(headers))).post(body).build();
            Response response = okHttpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    String errorText = response.body() != null ? response.body().string() : "Unknown error";
                    logger.error("HTTP request failed, status_code: {}, text: {}", (Object)response.code(), (Object)errorText);
                    throw new TboxHttpResponseException(response.code(), String.format("HTTP request failed, status_code: %d, text: %s", response.code(), errorText));
                }
                String responseText = response.body() != null ? response.body().string() : "";
                logger.info("HTTP request success, status_code: {}, text: {}", (Object)response.code(), (Object)responseText);
                string = responseText;
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JSONException e) {
                    throw new TboxClientConfigException("Failed to serialize request data", e);
                }
                catch (IOException e) {
                    throw new TboxHttpResponseException("Failed to execute request", e);
                }
            }
            response.close();
        }
        return string;
    }

    public Iterable<HttpResponseEvent> postStream(String path, Map<String, Object> data, Map<String, String> headers, final int timeout) throws TboxClientConfigException {
        String url = this.buildUrl(path);
        try {
            String json = JSON.toJSONString(data);
            RequestBody body = RequestBody.create((String)json, (MediaType)JSON_MEDIA_TYPE);
            Request request = new Request.Builder().url(url).headers(Headers.of(this.generateHeaders(headers))).post(body).build();
            final LinkedBlockingQueue eventQueue = new LinkedBlockingQueue();
            EventSourceListener listener = new EventSourceListener(){

                public void onEvent(EventSource eventSource, String id, String type, String data) {
                    eventQueue.add(new HttpResponseEvent(type, data, id));
                }

                public void onFailure(EventSource eventSource, Throwable t, Response response) {
                    String errorMessage = "Request TBox failed with HTTP code";
                    if (response != null) {
                        try {
                            errorMessage = errorMessage + ": " + response.code() + ", error message: " + Objects.requireNonNull(response.body()).string();
                        }
                        catch (IOException e) {
                            logger.error("Failed to get response body", (Throwable)e);
                        }
                    }
                    logger.error(errorMessage, t);
                    HashMap<String, String> errorContext = new HashMap<String, String>();
                    if (t != null) {
                        errorContext.put("errorMsg", t.getMessage());
                    } else {
                        errorContext.put("errorMsg", errorMessage);
                    }
                    try {
                        eventQueue.add(new HttpResponseEvent("error", JSON.toJSONString(errorContext)));
                    }
                    catch (JSONException e) {
                        eventQueue.add(new HttpResponseEvent("error", "{\"errorMsg\":\"Failed to serialize error context\"}"));
                    }
                    eventSource.cancel();
                }

                public void onClosed(EventSource eventSource) {
                    eventQueue.add(new HttpResponseEvent("close", "Connection closed"));
                }
            };
            OkHttpClient customClient = okHttpClient.newBuilder().readTimeout((long)timeout, TimeUnit.SECONDS).build();
            EventSource.Factory factory = EventSources.createFactory((OkHttpClient)customClient);
            final EventSource eventSource = factory.newEventSource(request, listener);
            return () -> new Iterator<HttpResponseEvent>(){
                private HttpResponseEvent nextEvent;
                private boolean closed = false;

                @Override
                public boolean hasNext() {
                    if (this.closed) {
                        return false;
                    }
                    if (this.nextEvent != null) {
                        return true;
                    }
                    try {
                        this.nextEvent = (HttpResponseEvent)eventQueue.poll(timeout, TimeUnit.SECONDS);
                        if (this.nextEvent == null || "close".equals(this.nextEvent.getEvent())) {
                            this.closed = true;
                            eventSource.cancel();
                            return false;
                        }
                        return true;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.closed = true;
                        eventSource.cancel();
                        return false;
                    }
                }

                @Override
                public HttpResponseEvent next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    HttpResponseEvent event = this.nextEvent;
                    this.nextEvent = null;
                    return event;
                }
            };
        }
        catch (JSONException e) {
            throw new TboxClientConfigException("Failed to serialize request data", e);
        }
    }

    public Response get(String url, Map<String, String> query, Map<String, String> headers) throws TboxHttpResponseException {
        HttpUrl.Builder httpBuilder = HttpUrl.parse((String)url).newBuilder();
        if (query != null) {
            for (Map.Entry<String, String> entry : query.entrySet()) {
                httpBuilder.addQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        Request request = new Request.Builder().url(httpBuilder.build()).headers(Headers.of(this.generateHeaders(headers))).get().build();
        try {
            return okHttpClient.newCall(request).execute();
        }
        catch (IOException e) {
            throw new TboxHttpResponseException("Failed to execute request", e);
        }
    }

    private String buildUrl(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return String.format("%s://%s%s", this.httpClientConfig.getSchema(), this.httpClientConfig.getHost(), path);
    }

    private Map<String, String> generateHeaders(Map<String, String> headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (headers != null) {
            result.putAll(headers);
        }
        if (this.httpClientConfig.getAuthorization() != null) {
            result.put("Authorization", this.httpClientConfig.getAuthorization());
        }
        if (result.get("Content-Type") == null) {
            result.put("Content-Type", "application/json");
        }
        return result;
    }
}

