package cn.tbox.sdk.core.http;

/**
 * HTTP response event.
 * Used to hold HTTP SSE response event messages.
 */
public class HttpResponseEvent {
    /**
     * HTTP response event ID.
     */
    private String id;
    
    /**
     * HTTP response event type.
     */
    private String event;
    
    /**
     * HTTP response event data.
     */
    private String data;

    public HttpResponseEvent(String event, String data) {
        this.event = event;
        this.data = data;
    }

    public HttpResponseEvent(String event, String data, String id) {
        this.event = event;
        this.data = data;
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEvent() {
        return event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }
} 