/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.client.spring;

import cn.feiliu.taskflow.annotations.WorkerTask;
import cn.feiliu.taskflow.executor.task.Worker;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Service;

class WorkerTasksScanner
implements BeanPostProcessor {
    private final Map<Class<?>, Object> workerBeans = new ConcurrentHashMap();

    WorkerTasksScanner() {
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (Worker.class.isAssignableFrom(bean.getClass())) {
            this.workerBeans.put(bean.getClass(), bean);
        } else if (bean.getClass().isAnnotationPresent(Service.class)) {
            Method[] methods;
            for (Method method : methods = bean.getClass().getDeclaredMethods()) {
                WorkerTask annotation = (WorkerTask)AnnotationUtils.findAnnotation((Method)method, WorkerTask.class);
                if (annotation == null) continue;
                this.workerBeans.put(bean.getClass(), bean);
                break;
            }
        }
        return bean;
    }

    public Collection<Object> getWorkerBeans() {
        return this.workerBeans.values();
    }
}

