/*
 * Decompiled with CFR 0.152.
 */
package cn.feiliu.taskflow.client.spring;

import cn.feiliu.taskflow.client.ApiClient;
import cn.feiliu.taskflow.client.spring.WorkerTasksScanner;
import cn.feiliu.taskflow.utils.TaskflowConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

public class ApiClientAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ApiClientAutoConfiguration.class);

    @Bean
    public TaskflowConfig getConfig(Environment env) {
        TaskflowConfig config = new TaskflowConfig();
        config.setBaseUrl(env.getProperty("taskflow.base-url"));
        config.setKeyId(env.getProperty("taskflow.key-id"));
        config.setKeySecret(env.getProperty("taskflow.key-secret"));
        config.setWebSocketUrl(env.getProperty("taskflow.web-socket-url"));
        config.setAutoRegister((Boolean)env.getProperty("taskflow.auto-register", Boolean.class));
        config.setUpdateExisting((Boolean)env.getProperty("taskflow.update-existing", Boolean.class));
        config.setWebSocketUrl(env.getProperty("taskflow.web-socket-url"));
        return config;
    }

    @Bean(value={"workerTasksScanner"})
    public WorkerTasksScanner workerTasksScanner() {
        return new WorkerTasksScanner();
    }

    @Bean(value={"apiClient"})
    @DependsOn(value={"workerTasksScanner"})
    public ApiClient apiClient(TaskflowConfig config, WorkerTasksScanner workerTasksScanner) {
        ApiClient apiClient = new ApiClient(config);
        apiClient.addWorker(workerTasksScanner.getWorkerBeans());
        return apiClient.start();
    }
}

