/*
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.feiliu.protogen.protobuf.compiler;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.xolstice.maven.plugin.protobuf.ProtocCompileMojo;

import java.io.File;
import java.lang.reflect.Field;

public class MavenProtobufCompiler {
    private final String protoSourceRoot;
    private final String outputDirectory;
    private final String protocVersion;
    private final String grpcVersion;

    public MavenProtobufCompiler(String protoSourceRoot, String outputDirectory, String protocVersion,
                                 String grpcVersion) {
        this.protoSourceRoot = protoSourceRoot;
        this.outputDirectory = outputDirectory;
        this.protocVersion = protocVersion;
        this.grpcVersion = grpcVersion;
    }

    public void compile() throws MojoExecutionException, MojoFailureException {
        // 创建Maven插件配置
        ProtocCompileMojo mojo = new ProtocCompileMojo();
        // 设置必要的属性
        setField(mojo, "protoSourceRoot", new File(protoSourceRoot));
        setField(mojo, "outputDirectory", new File(outputDirectory));
        setField(mojo, "protocVersion", protocVersion);
        setField(mojo, "grpcVersion", grpcVersion);

        // 执行编译
        mojo.execute();
    }

    private void setField(Object object, String fieldName, Object value) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, value);
        } catch (Exception e) {
            throw new RuntimeException("Failed to set field: " + fieldName, e);
        }
    }
}