/*
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.feiliu.protogen.proto;

import cn.feiliu.conductor.annotationsprocessor.protogen.ProtoGen;
import cn.feiliu.protogen.config.ProtoConfig;
import cn.feiliu.protogen.config.ProtoGenConfiguration;
import cn.feiliu.protogen.protobuf.compiler.ProtobufCompilerUtil;

import java.io.File;
import java.io.IOException;

/**
 * 代码生成
 *
 * @author SHOUSHEN.LUAN
 * @since 2024-12-17
 */
public class CodeGenerator {
    public final ProtoGenConfiguration config;

    public CodeGenerator(ProtoGenConfiguration config) {
        this.config = config;
    }

    private String getProtoSourceRoot() {
        return config.getBaseConfig().getProtoSourceRootFile().getAbsolutePath();
    }

    private String getJavaSourceRoot() {
        return config.getBaseConfig().getOutputDirectoryFile().getAbsolutePath();
    }

    /**
     * 从 jar 包中的类来生成Proto
     *
     * @param jarFile
     * @throws IOException
     */
    public void fromJarGenerateProto(File jarFile) throws IOException {
        ProtoConfig protoConfig = config.getProtoConfig();
        ProtoGen generator = new ProtoGen(protoConfig.getProtoPath(), protoConfig.getJavaPackage(),
            protoConfig.getGoPackage());
        generator.processPackage(jarFile, protoConfig.getSourcePackage());
    }

    /**
     * 根据Java类生成Proto
     *
     * @param pojos
     * @throws IOException
     */
    public void generateProto(Class<?>... pojos) throws IOException {
        ProtoConfig protoConfig = config.getProtoConfig();
        for (Class<?> pojo : pojos) {
            ProtoGen generator = new ProtoGen(protoConfig.getProtoPath(), protoConfig.getJavaPackage(),
                protoConfig.getGoPackage());
            generator.processClass(pojo);
            File mapperFile = new File(getJavaSourceRoot(), protoConfig.getMapperPackage().replace('.', '/'));
            generator.writeMapper(mapperFile, protoConfig.getMapperPackage());
            generator.writeProtos(new File(getProtoSourceRoot()));
        }
    }

    public void compileProto() {
        ProtobufCompilerUtil.compileProto(config);
    }
}
