/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.trpc.fromwork.spring.provider;

import cn.tannn.trpc.common.api.RegistryCenter;
import cn.tannn.trpc.common.api.RpcRequest;
import cn.tannn.trpc.common.api.RpcResponse;
import cn.tannn.trpc.common.properties.RpcProperties;
import cn.tannn.trpc.core.providers.ProviderBootstrap;
import cn.tannn.trpc.core.providers.ProviderInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.function.RequestPredicate;
import org.springframework.web.servlet.function.RequestPredicates;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerResponse;

@AutoConfiguration
public class ProvidersConfig {
    private static final Logger log = LoggerFactory.getLogger(ProvidersConfig.class);

    @Bean
    ProviderBootstrap providersBootstrap(@Autowired RegistryCenter registryCenter, @Autowired RpcProperties rpcProperties) {
        return new ProviderBootstrap(registryCenter, rpcProperties);
    }

    @Bean
    ProviderInvoker providersInvoker(@Autowired ProviderBootstrap providersBootstrap, @Autowired RpcProperties rpcProperties) {
        return new ProviderInvoker(providersBootstrap, rpcProperties);
    }

    @Bean
    @Order(value=-2147483647)
    public ApplicationRunner providerBootstrapRunner(@Autowired ProviderBootstrap providerBootstrap, @Autowired Environment environment) {
        return x -> providerBootstrap.start((Integer)environment.getProperty("server.port", Integer.class));
    }

    @Bean
    @ConditionalOnProperty(value={"trpc.api.enabled"}, havingValue="true", matchIfMissing=true)
    public RouterFunction<ServerResponse> invoke(@Autowired ProviderInvoker providerInvoker, @Autowired RpcProperties rpcProperties) {
        String context = rpcProperties.getApi().getContext();
        log.debug("rpc api name http://ip:port/{}", (Object)context);
        return RouterFunctions.route((RequestPredicate)RequestPredicates.POST((String)context).and(RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON}).and(RequestPredicates.contentType((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON}))), request -> {
            RpcRequest rpcRequest = (RpcRequest)request.body(RpcRequest.class);
            RpcResponse invoke = providerInvoker.invoke(rpcRequest);
            return ServerResponse.ok().body((Object)invoke);
        });
    }
}

