/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.trpc.fromwork.spring.consumer;

import cn.tannn.trpc.core.api.RegistryCenter;
import cn.tannn.trpc.core.providers.ProviderBootstrap;
import jakarta.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;

@AutoConfiguration
@ConditionalOnMissingBean(value={ProviderBootstrap.class})
public class ConsumerPreDestroy {
    private static final Logger log = LoggerFactory.getLogger(ConsumerPreDestroy.class);
    @Autowired
    private ApplicationContext context;

    @PreDestroy
    public void stop() {
        log.info("ConsumerBootstrap stop...");
        RegistryCenter registryCenter = (RegistryCenter)this.context.getBean(RegistryCenter.class);
        registryCenter.stop();
        log.info("ConsumerBootstrap stopped.");
    }
}

