/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.trpc.fromwork.spring.consumer;

import cn.tannn.trpc.core.api.LoadBalancer;
import cn.tannn.trpc.core.api.Router;
import cn.tannn.trpc.core.cluster.GrayRouter;
import cn.tannn.trpc.core.cluster.RandomLoadBalancer;
import cn.tannn.trpc.core.cluster.RoundRibbonLoadBalancer;
import cn.tannn.trpc.core.consumer.ConsumerBootstrap;
import cn.tannn.trpc.core.enums.FilterEnum;
import cn.tannn.trpc.core.enums.LoadBalancerEnum;
import cn.tannn.trpc.core.filter.FilterChain;
import cn.tannn.trpc.core.properties.RpcProperties;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

@AutoConfiguration
public class ConsumerConfig {
    private static final Logger log = LoggerFactory.getLogger(ConsumerConfig.class);

    @Bean
    ConsumerBootstrap createConsumerBootstrap(@Autowired RpcProperties rpcProperties) {
        return new ConsumerBootstrap(rpcProperties);
    }

    @Bean
    @Order(value=-2147483648)
    public ApplicationRunner consumerBootstrapRunner(ConsumerBootstrap consumerBootstrap) {
        return x -> consumerBootstrap.start();
    }

    @Bean
    LoadBalancer loadBalancer(RpcProperties rpcProperties) {
        if (rpcProperties.getConsumer().getLoadBalancer().equals((Object)LoadBalancerEnum.ROUND_RIBBON)) {
            return new RoundRibbonLoadBalancer();
        }
        return new RandomLoadBalancer();
    }

    @Bean
    FilterChain filterChain(RpcProperties rpcProperties) {
        List filters = FilterEnum.findFilter((FilterEnum[])rpcProperties.getConsumer().getFilter());
        return new FilterChain(filters);
    }

    @Bean
    Router router(RpcProperties rpcProperties) {
        return new GrayRouter(rpcProperties.getConsumer());
    }
}

