/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.trpc.registry.zk;

import cn.tannn.trpc.common.api.RegistryCenter;
import cn.tannn.trpc.common.exception.ExceptionCode;
import cn.tannn.trpc.common.exception.TrpcException;
import cn.tannn.trpc.common.listener.ChangedListener;
import cn.tannn.trpc.common.listener.Event;
import cn.tannn.trpc.common.meta.InstanceMeta;
import cn.tannn.trpc.common.meta.ServiceMeta;
import cn.tannn.trpc.common.properties.meta.GrayMetas;
import cn.tannn.trpc.common.properties.rc.Connect;
import cn.tannn.trpc.common.properties.rc.RegistryCenterProperties;
import com.alibaba.fastjson2.JSON;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.DeleteBuilderMain;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkRegistryCenter
implements RegistryCenter {
    private static final Logger log = LoggerFactory.getLogger(ZkRegistryCenter.class);
    private CuratorFramework client = null;
    private final RegistryCenterProperties rcp;
    TreeCache cacheGlobal = null;

    public ZkRegistryCenter(RegistryCenterProperties rcp) {
        this.rcp = rcp;
    }

    public void start() {
        if (this.client != null) {
            log.info("zkServer alive ... ");
            return;
        }
        log.info("zkServer start ...");
        ExponentialBackoffRetry retry = new ExponentialBackoffRetry(1000, 3);
        Connect[] connect = this.rcp.getConnect();
        if (connect == null || connect.length == 0) {
            throw new TrpcException(ExceptionCode.ZK_NOT_SETTING);
        }
        String connectString = connect[0].connectString();
        this.client = CuratorFrameworkFactory.builder().connectString(connectString).namespace(this.rcp.getNamespace()).retryPolicy((RetryPolicy)retry).build();
        log.info(" ===> zk client starting.");
        this.client.start();
    }

    public void stop() {
        if (this.cacheGlobal != null) {
            this.cacheGlobal.close();
        }
        this.client.close();
        log.info(" ===> zk client stopped.");
    }

    public void register(ServiceMeta service, InstanceMeta instance) {
        String servicePath = "/" + service.toPath();
        try {
            if (this.client.checkExists().forPath(servicePath) == null) {
                ((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.PERSISTENT)).forPath(servicePath, service.toMetas().getBytes());
            }
            String instancePath = servicePath + "/" + instance.toPath();
            log.info(" ===> register to zk: {}", (Object)instancePath);
            ((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.EPHEMERAL)).forPath(instancePath, instance.toGary().getBytes());
        }
        catch (Exception e) {
            throw new TrpcException((Throwable)e, ExceptionCode.ZK_REGISTER_FAIL);
        }
    }

    public void unregister(ServiceMeta service, InstanceMeta instance) {
        String servicePath = "/" + service.toPath();
        try {
            if (this.client.checkExists().forPath(servicePath) == null) {
                return;
            }
            String instancePath = servicePath + "/" + instance.toPath();
            log.info(" ===> unregister from zk: {}", (Object)instancePath);
            ((DeleteBuilderMain)this.client.delete().quietly()).forPath(instancePath);
        }
        catch (Exception e) {
            throw new TrpcException((Throwable)e, ExceptionCode.ZK_UNREGISTER_FAIL);
        }
    }

    public List<InstanceMeta> fetchAll(ServiceMeta service) {
        String servicePath = "/" + service.toPath();
        try {
            List nodes = (List)this.client.getChildren().forPath(servicePath);
            log.info(" ===> fetchAll from zk: {}", (Object)servicePath);
            return this.mapInstances(nodes, servicePath);
        }
        catch (Exception e) {
            throw new TrpcException((Throwable)e, ExceptionCode.ZK_FETCH_INSTANCE_FAIL);
        }
    }

    public void subscribe(ServiceMeta service, ChangedListener listener) {
        TreeCache cache = TreeCache.newBuilder((CuratorFramework)this.client, (String)("/" + service.toPath())).setCacheData(true).setMaxDepth(2).build();
        cache.getListenable().addListener((curator, event) -> {
            log.info("zk subscribe event: {}", (Object)event);
            List<InstanceMeta> nodes = this.fetchAll(service);
            listener.fire(new Event(nodes));
        });
        cache.start();
        this.cacheGlobal = cache;
    }

    private List<InstanceMeta> mapInstances(List<String> nodes, String servicePath) {
        return nodes.stream().map(x -> {
            byte[] bytes;
            String[] split = x.split("_");
            InstanceMeta instance = InstanceMeta.http((String)split[0], (Integer)Integer.valueOf(split[1]), (String)split[2]);
            log.debug(" fetchAll instance: {}", (Object)instance.toUrl());
            String nodePath = servicePath + "/" + x;
            try {
                bytes = (byte[])this.client.getData().forPath(nodePath);
            }
            catch (Exception e) {
                throw new TrpcException("\u5b9e\u4f8b\u8282\u70b9\u6570\u636e\u8bfb\u53d6\u5931\u8d25", (Throwable)e);
            }
            GrayMetas grayMetas = (GrayMetas)JSON.parseObject((String)new String(bytes), GrayMetas.class);
            log.debug("zk GrayMetas : {}", (Object)grayMetas);
            instance.setGray(grayMetas);
            return instance;
        }).collect(Collectors.toList());
    }
}

