/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.trpc.common.properties;

import cn.tannn.trpc.common.enums.FilterEnum;
import cn.tannn.trpc.common.enums.LoadBalancerEnum;
import cn.tannn.trpc.common.properties.HttpProperties;
import cn.tannn.trpc.common.properties.IsolateProperties;
import cn.tannn.trpc.common.properties.SubscribeProperties;
import java.util.Arrays;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

public class ConsumerProperties {
    private LoadBalancerEnum loadBalancer;
    private FilterEnum[] filter;
    private Integer grayRatio = 0;
    @NestedConfigurationProperty
    private HttpProperties http = new HttpProperties();
    @NestedConfigurationProperty
    private SubscribeProperties subscribe = new SubscribeProperties();
    @NestedConfigurationProperty
    private IsolateProperties isolate = new IsolateProperties();

    public LoadBalancerEnum getLoadBalancer() {
        if (this.loadBalancer == null) {
            return LoadBalancerEnum.RANDOM;
        }
        return this.loadBalancer;
    }

    public FilterEnum[] getFilter() {
        if (this.filter == null || this.filter.length == 0) {
            return new FilterEnum[]{FilterEnum.DEFAULT};
        }
        return this.filter;
    }

    public Integer getGrayRatio() {
        if (this.grayRatio == null || this.grayRatio < 0) {
            return 0;
        }
        if (this.grayRatio > 100) {
            return 100;
        }
        return this.grayRatio;
    }

    public HttpProperties getHttp() {
        return this.http;
    }

    public SubscribeProperties getSubscribe() {
        return this.subscribe;
    }

    public IsolateProperties getIsolate() {
        return this.isolate;
    }

    public void setLoadBalancer(LoadBalancerEnum loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public void setFilter(FilterEnum[] filter) {
        this.filter = filter;
    }

    public void setGrayRatio(Integer grayRatio) {
        this.grayRatio = grayRatio;
    }

    public void setHttp(HttpProperties http) {
        this.http = http;
    }

    public void setSubscribe(SubscribeProperties subscribe) {
        this.subscribe = subscribe;
    }

    public void setIsolate(IsolateProperties isolate) {
        this.isolate = isolate;
    }

    public String toString() {
        return "ConsumerProperties(loadBalancer=" + this.getLoadBalancer() + ", filter=" + Arrays.deepToString((Object[])this.getFilter()) + ", grayRatio=" + this.getGrayRatio() + ", http=" + this.getHttp() + ", subscribe=" + this.getSubscribe() + ", isolate=" + this.getIsolate() + ")";
    }
}

