/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.trpc.common.meta;

import cn.tannn.trpc.common.properties.meta.GrayMetas;
import com.alibaba.fastjson2.JSON;

public class InstanceMeta {
    private String schema;
    private String host;
    private Integer port;
    private String context;
    private GrayMetas gray;

    public InstanceMeta(String schema, String host, Integer port, String context) {
        this.schema = schema;
        this.host = host;
        this.port = port;
        this.context = context;
    }

    public String toPath() {
        return String.format("%s_%d_%s", this.host, this.port, this.context);
    }

    public static InstanceMeta http(String host, Integer port) {
        return new InstanceMeta("http", host, port, "");
    }

    public static InstanceMeta http(String host, Integer port, String context) {
        return new InstanceMeta("http", host, port, context);
    }

    public String toUrl() {
        return String.format("%s://%s:%d/%s", this.schema, this.host, this.port, this.context);
    }

    public String toGary() {
        return JSON.toJSONString((Object)this.gray);
    }

    public String getSchema() {
        return this.schema;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getContext() {
        return this.context;
    }

    public GrayMetas getGray() {
        return this.gray;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setGray(GrayMetas gray) {
        this.gray = gray;
    }

    public String toString() {
        return "InstanceMeta(schema=" + this.getSchema() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", context=" + this.getContext() + ", gray=" + this.getGray() + ")";
    }

    public InstanceMeta() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstanceMeta)) {
            return false;
        }
        InstanceMeta other = (InstanceMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        return !(this$context == null ? other$context != null : !this$context.equals(other$context));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InstanceMeta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        return result;
    }
}

