/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.trpc.common.exception;

import cn.tannn.trpc.common.exception.ExceptionCode;

public class TrpcException
extends RuntimeException {
    private ExceptionCode exceptionCode;

    public TrpcException() {
    }

    public TrpcException(String message) {
        super(message);
    }

    public TrpcException(String message, Throwable cause) {
        super(message, cause);
    }

    public TrpcException(Throwable cause) {
        super(cause);
    }

    public TrpcException(Throwable cause, ExceptionCode errcode) {
        super(cause);
        this.exceptionCode = errcode;
    }

    public TrpcException(ExceptionCode errcode) {
        super(errcode.getMessage());
        this.exceptionCode = errcode;
    }

    public TrpcException(String message, ExceptionCode errcode) {
        super(message);
        this.exceptionCode = errcode;
    }

    @Override
    public String getMessage() {
        if (null == this.exceptionCode) {
            return super.getMessage();
        }
        return this.exceptionCode.getType() + this.exceptionCode.getCode() + "-" + this.exceptionCode.getMessage() + "-" + super.getMessage();
    }

    public String getExceptionCodeStr() {
        return this.exceptionCode.getType() + this.exceptionCode.getCode() + "-" + this.exceptionCode.getMessage() + "-" + super.getMessage();
    }

    public ExceptionCode getExceptionCode() {
        return this.exceptionCode;
    }

    public void setExceptionCode(ExceptionCode exceptionCode) {
        this.exceptionCode = exceptionCode;
    }

    @Override
    public String toString() {
        return "TrpcException(exceptionCode=" + this.getExceptionCode() + ")";
    }
}

