/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.trpc.common.chain;

import cn.tannn.trpc.common.api.Filter;
import cn.tannn.trpc.common.api.RpcRequest;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterChain {
    private static final Logger log = LoggerFactory.getLogger(FilterChain.class);
    private final List<Filter> filters;

    public FilterChain(List<Filter> filters) {
        filters.sort(Comparator.comparing(Filter::getOrder).reversed());
        this.filters = filters;
    }

    public Object executePref(RpcRequest rpcRequest) {
        Object prefilter = null;
        for (Filter filter : this.filters) {
            prefilter = filter.prefilter(rpcRequest);
            log.debug(" {} ===> prefilter {}", (Object)filter.getClass().getName(), (Object)rpcRequest);
        }
        return prefilter;
    }

    public Object executePost(RpcRequest rpcRequest, Object result) {
        for (Filter filter : this.filters) {
            Object filterResult = filter.postFilter(rpcRequest, result);
            log.debug(" {} ===> post filter", (Object)filter.getClass().getName());
            if (filterResult == null) continue;
            result = filterResult;
        }
        return result;
    }
}

