/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.cat.file.sdk.core.minio;

import cn.tannn.cat.file.sdk.OssOperateAPI;
import cn.tannn.cat.file.sdk.api.UploadFile;
import cn.tannn.cat.file.sdk.bean.FileIndex;
import cn.tannn.cat.file.sdk.bean.FileStorage;
import cn.tannn.cat.file.sdk.config.MinioConfig;
import cn.tannn.cat.file.sdk.core.minio.MinioUtils;
import cn.tannn.cat.file.sdk.exception.FileException;
import cn.tannn.cat.file.sdk.utils.AboutFileUtil;
import cn.tannn.cat.file.sdk.utils.ResponseFile;
import com.alibaba.fastjson2.JSONReader;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MinioOperate
implements OssOperateAPI {
    private static final Logger log = LoggerFactory.getLogger(MinioOperate.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileIndex uploadFile(UploadFile upload, FileStorage storage) throws IOException {
        MinioConfig minioConfig = (MinioConfig)storage.getConfig().toJavaObject(MinioConfig.class, new JSONReader.Feature[0]);
        MinioUtils.makeBucket(storage.getId(), upload.getBucket());
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String builtInNames = sdf.format(date).trim();
        Objects.requireNonNull(upload.getFile().getOriginalFilename());
        String originalName = upload.getFile().getOriginalFilename();
        String suffixDot = AboutFileUtil.getFileSuffixDot(originalName);
        String freshName = StringUtils.isNotBlank((CharSequence)upload.getFileName()) ? upload.getFileName().trim() + suffixDot : builtInNames + suffixDot;
        String uploadPath = StringUtils.isNotBlank((CharSequence)upload.getChildFolder()) && !"null".equalsIgnoreCase(upload.getChildFolder()) ? upload.getChildFolder() + freshName : freshName;
        try (InputStream in = upload.getFile().getInputStream();){
            String contentType = upload.getFile().getContentType();
            MinioClient minioClient = MinioUtils.getMinioClient(storage.getId());
            minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(upload.getBucket())).object(uploadPath)).stream(in, (long)in.available(), -1L).contentType(contentType).build());
            String urlSuffix = "/" + upload.getBucket() + "/" + uploadPath;
            String url = minioConfig.getBrowseUrl() + urlSuffix;
            FileIndex fileStorage = new FileIndex();
            fileStorage.setStorageId(storage.getId());
            fileStorage.setStorage(storage.getStorage());
            fileStorage.setOriginalName(originalName);
            fileStorage.setFreshName(freshName);
            fileStorage.setPath(uploadPath);
            fileStorage.setUrl(url);
            fileStorage.setUrlSuffix(urlSuffix);
            fileStorage.setBucket(upload.getBucket());
            fileStorage.setType(upload.getFile().getContentType());
            fileStorage.setSizeUnit(AboutFileUtil.getFileSizeUnit(upload.getFile().getSize()));
            fileStorage.setSize(String.valueOf(upload.getFile().getSize()));
            FileIndex fileIndex = fileStorage;
            return fileIndex;
        }
        catch (Exception e) {
            throw new FileException("MINIO\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", e);
        }
    }

    @Override
    public boolean removeFile(FileIndex index) {
        try {
            boolean flag = MinioUtils.bucketExists(index.getStorageId(), index.getBucket());
            if (flag) {
                MinioUtils.getMinioClient(index.getStorageId()).removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(index.getBucket())).object(index.getPath())).build());
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error("minio\u5220\u9664\u5931\u8d25\uff1aindex id : {} , URL: {}", new Object[]{index.getId(), index.getUrl(), e});
            throw new FileException("\u6587\u4ef6\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public void downloadFile(HttpServletResponse response, FileIndex index) {
        try (InputStream in = MinioUtils.fileInputStream(index.getStorageId(), index.getBucket(), index.getPath());){
            HttpServletResponse downResponse = ResponseFile.customResponse(response, index.getType(), index.getFreshName());
            downResponse.setHeader("Content-Length", String.valueOf(index.getSize()));
            IOUtils.copy((InputStream)in, (OutputStream)downResponse.getOutputStream());
        }
        catch (Exception e) {
            log.error("minio\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1aindex id : {} , URL: {}", new Object[]{index.getId(), index.getUrl(), e});
        }
    }
}

