/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.cat.file.sdk.core.ftp;

import cn.tannn.cat.file.sdk.bean.FileStorage;
import cn.tannn.cat.file.sdk.config.FtpConfig;
import cn.tannn.cat.file.sdk.core.OssCache;
import cn.tannn.cat.file.sdk.exception.FileException;
import com.alibaba.fastjson2.JSONReader;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpUtils {
    private static final Logger log = LoggerFactory.getLogger(FtpUtils.class);

    public static FTPClient createFtpClient(Long fileStorageId) {
        FileStorage fileStorage = OssCache.ftpConnectInfoCache.get(fileStorageId);
        return FtpUtils.createFtpClient(fileStorage);
    }

    public static FTPClient createFtpClient(FileStorage fileStorage) {
        FTPClient ftpClient = new FTPClient();
        try {
            FtpConfig ftpConfig = (FtpConfig)fileStorage.getConfig().toJavaObject(FtpConfig.class, new JSONReader.Feature[0]);
            if (Objects.nonNull(ftpConfig)) {
                FtpUtils.connectAndLogin(ftpClient, ftpConfig);
                int replyCode = ftpClient.getReplyCode();
                if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                    log.error("===> ftp\u300a{}\u300bconnect failed \uff0cftp\u670d\u52a1\u5668: {}:{}", new Object[]{fileStorage.getName(), ftpConfig.getHostname(), ftpConfig.getPort()});
                    ftpClient.abort();
                    ftpClient.disconnect();
                }
                ftpClient.setControlEncoding("utf-8");
                ftpClient.sendCommand("OPTS UTF8", "ON");
                log.info("===> ftp\u300a{}\u300bconnect success", (Object)fileStorage.getName());
            }
            return ftpClient;
        }
        catch (Exception e) {
            log.error("===>  ftp\u300a{}\u300b\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5", (Object)fileStorage.getName(), (Object)e);
            throw new FileException("===>  ftp\u300a{}\u300b\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5", e);
        }
    }

    public static void disConnection(FTPClient ftpClient) {
        try {
            if (ftpClient.isConnected()) {
                ftpClient.disconnect();
            }
        }
        catch (IOException e) {
            log.error("ftp client coles err", (Throwable)e);
        }
    }

    public static void deleteFtpConnectInfo(Long fileStorageId) {
        try {
            OssCache.ftpConnectInfoCache.remove(fileStorageId);
        }
        catch (Exception e) {
            log.error("\u5220\u9664ftp connect info cache \u5931\u8d25 fileStorageId {}", (Object)fileStorageId, (Object)e);
        }
    }

    public static void createMultiLevelDirectory(FTPClient ftp, String dirPath) throws IOException {
        String[] dirs = dirPath.split("/");
        String currentPath = "";
        for (String dir : dirs) {
            if (dir == null || dir.trim().isEmpty() || FtpUtils.directoryExists(ftp, currentPath = currentPath + "/" + dir)) continue;
            boolean created = ftp.makeDirectory(currentPath);
            if (created) {
                log.info("Directory created successfully: {}", (Object)currentPath);
                continue;
            }
            log.info("Failed to create directory: {}", (Object)currentPath);
        }
    }

    public static boolean directoryExists(FTPClient ftp, String dirPath) throws IOException {
        ftp.changeWorkingDirectory(dirPath);
        int returnCode = ftp.getReplyCode();
        return returnCode == 250;
    }

    public static void checkAndReconnect(FTPClient ftp, FtpConfig ftpConfig) throws IOException {
        if (!ftp.isConnected() || !ftp.sendNoOp()) {
            FtpUtils.connectAndLogin(ftp, ftpConfig);
        }
    }

    public static void connectAndLogin(FTPClient ftpClient, FtpConfig ftpConfig) throws IOException {
        ftpClient.connect(ftpConfig.getHostname(), ftpConfig.getPort().intValue());
        if (StringUtils.isNotBlank((CharSequence)ftpConfig.getUsername()) && StringUtils.isNotBlank((CharSequence)ftpConfig.getPassword())) {
            ftpClient.login(ftpConfig.getUsername(), ftpConfig.getPassword());
        } else {
            ftpClient.login("Anonymous", "");
        }
    }
}

