/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.cat.file.sdk.core.ftp;

import cn.tannn.cat.file.sdk.OssOperateAPI;
import cn.tannn.cat.file.sdk.api.UploadFile;
import cn.tannn.cat.file.sdk.bean.FileIndex;
import cn.tannn.cat.file.sdk.bean.FileStorage;
import cn.tannn.cat.file.sdk.config.FtpConfig;
import cn.tannn.cat.file.sdk.core.ftp.FtpUtils;
import cn.tannn.cat.file.sdk.exception.FileException;
import cn.tannn.cat.file.sdk.utils.AboutFileUtil;
import cn.tannn.cat.file.sdk.utils.ResponseFile;
import com.alibaba.fastjson2.JSONReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FtpOperate
implements OssOperateAPI {
    private static final Logger log = LoggerFactory.getLogger(FtpOperate.class);

    @Override
    public FileIndex uploadFile(UploadFile upload, FileStorage storage) throws IOException {
        FTPClient ftpClient = FtpUtils.createFtpClient(storage);
        try {
            FtpConfig ftpConfig = (FtpConfig)storage.getConfig().toJavaObject(FtpConfig.class, new JSONReader.Feature[0]);
            String originalName = upload.getFile().getOriginalFilename();
            if (originalName == null) {
                throw new FileException("\u6587\u4ef6\u6709\u95ee\u9898\uff0cOriginalFilename \u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            String suffixDot = AboutFileUtil.getFileSuffixDot(originalName);
            String freshName = StringUtils.isNotBlank((CharSequence)upload.getFileName()) ? upload.getFileName().trim() + suffixDot : originalName;
            String childFolder = Objects.isNull(upload.getChildFolder()) ? "" : upload.getChildFolder();
            String uploadDirStr = upload.getBucket() + "/" + childFolder;
            String uploadDir = new String(uploadDirStr.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
            String filePathStr = "/" + uploadDir + freshName;
            String filePath = new String(filePathStr.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
            FtpUtils.createMultiLevelDirectory(ftpClient, uploadDir);
            ftpClient.setFileType(2);
            InputStream inputStream = upload.getFile().getInputStream();
            ftpClient.storeFile(filePath, inputStream);
            ftpClient.enterLocalPassiveMode();
            inputStream.close();
            ftpClient.logout();
            FileIndex fileStorage = new FileIndex();
            fileStorage.setStorageId(storage.getId());
            fileStorage.setStorage(storage.getStorage());
            fileStorage.setOriginalName(originalName);
            fileStorage.setFreshName(freshName);
            fileStorage.setPath(filePathStr);
            fileStorage.setUrl(ftpConfig.getBrowseUrl() + ftpConfig.getUsePrefix() + storage.getStorage() + "?filePath=" + filePathStr);
            fileStorage.setUrlSuffix(ftpConfig.getUsePrefix() + storage.getStorage() + "?filePath=" + filePathStr);
            fileStorage.setBucket(upload.getBucket());
            fileStorage.setType(upload.getFile().getContentType());
            fileStorage.setSizeUnit(AboutFileUtil.getFileSizeUnit(upload.getFile().getSize()));
            fileStorage.setSize(String.valueOf(upload.getFile().getSize()));
            FileIndex fileIndex = fileStorage;
            return fileIndex;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            FtpUtils.disConnection(ftpClient);
        }
    }

    @Override
    public boolean removeFile(FileIndex index) {
        FTPClient ftpClient = FtpUtils.createFtpClient(index.getStorageId());
        try {
            ftpClient.deleteFile(index.getPath());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("ftp\u5220\u9664\u5931\u8d25\uff1aindex id : {} , URL: {}", new Object[]{index.getId(), index.getUrl(), e});
            throw new FileException("\u6587\u4ef6\u5220\u9664\u5931\u8d25");
        }
        finally {
            FtpUtils.disConnection(ftpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadFile(HttpServletResponse response, FileIndex index) {
        FTPClient ftpClient = FtpUtils.createFtpClient(index.getStorageId());
        try {
            String fileNameEncoding = new String(index.getPath().getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
            InputStream inputStream = ftpClient.retrieveFileStream(fileNameEncoding);
            HttpServletResponse downResponse = ResponseFile.customResponse(response, index.getType(), index.getFreshName());
            downResponse.setHeader("Content-Length", String.valueOf(index.getSize()));
            IOUtils.copy((InputStream)inputStream, (OutputStream)downResponse.getOutputStream());
        }
        catch (Exception e) {
            log.error("ftp\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1aindex id : {} , URL: {}", new Object[]{index.getId(), index.getUrl(), e});
        }
        finally {
            FtpUtils.disConnection(ftpClient);
        }
    }
}

