/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.cat.file.sdk.utils;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.servlet.http.HttpServletResponse;

public class ResponseFile {
    public static HttpServletResponse xlsxResponse(HttpServletResponse response, String title) throws UnsupportedEncodingException {
        return ResponseFile.customResponse(response, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", title, ".xlsx");
    }

    public static HttpServletResponse jsonResponse(HttpServletResponse response, String title) throws UnsupportedEncodingException {
        return ResponseFile.customResponse(response, "application/json", title, ".json");
    }

    public static HttpServletResponse zipResponse(HttpServletResponse response, String title) throws UnsupportedEncodingException {
        return ResponseFile.customResponse(response, "application/zip", title, ".zip");
    }

    public static HttpServletResponse csvResponse(HttpServletResponse response, String title) throws UnsupportedEncodingException {
        return ResponseFile.customResponse(response, "text/csv;charset=utf-8", title, ".csv");
    }

    public static HttpServletResponse fileResponse(HttpServletResponse response, File file) throws IOException {
        String contentType = Files.probeContentType(Paths.get(file.getAbsolutePath(), new String[0])) + ";charset=utf-8";
        HttpServletResponse fileResponseBase = ResponseFile.customResponse(response, contentType, file.getName());
        fileResponseBase.setHeader("Content-Length", String.valueOf(file.length()));
        return fileResponseBase;
    }

    public static HttpServletResponse customResponse(HttpServletResponse response, String contentType, String title, String fileFormat) throws UnsupportedEncodingException {
        return ResponseFile.customResponse(response, contentType, title + fileFormat);
    }

    public static HttpServletResponse customResponse(HttpServletResponse response, String contentType, String filename) throws UnsupportedEncodingException {
        response.reset();
        response.setContentType(contentType);
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode(filename, "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName);
        return response;
    }
}

