/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.cat.file.sdk.core.qiniu;

import cn.tannn.cat.file.sdk.bean.FileStorage;
import cn.tannn.cat.file.sdk.config.QiNiuConfig;
import cn.tannn.cat.file.sdk.core.OssCache;
import cn.tannn.cat.file.sdk.core.qiniu.QiNiuClient;
import com.alibaba.fastjson2.JSONReader;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QiNiuUtils {
    private static final Logger log = LoggerFactory.getLogger(QiNiuUtils.class);

    public static void createQiNiuClient(FileStorage storage) {
        try {
            QiNiuConfig qiNiuConfig = (QiNiuConfig)storage.getConfig().toJavaObject(QiNiuConfig.class, new JSONReader.Feature[0]);
            if (Objects.nonNull(qiNiuConfig)) {
                QiNiuClient qiNiuClient = new QiNiuClient();
                Auth auth = QiNiuUtils.auth(qiNiuConfig);
                Configuration configuration = QiNiuUtils.qiniuConfig(qiNiuConfig);
                UploadManager uploadManager = QiNiuUtils.uploadManager(configuration);
                BucketManager bucketManager = QiNiuUtils.bucketManager(auth, configuration);
                qiNiuClient.setUploadManager(uploadManager);
                qiNiuClient.setBucketManager(bucketManager);
                qiNiuClient.setAuth(auth);
                OssCache.qiNiuClientCache.put(storage.getId(), qiNiuClient);
            }
        }
        catch (Exception e) {
            log.error("\u4e03\u725b\u300a{}\u300b\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5", (Object)storage.getName(), (Object)e);
        }
    }

    public static String getUploadToken(String bucket, Auth auth) {
        StringMap policy = new StringMap();
        return auth.uploadToken(bucket, null, 3600L, policy);
    }

    private static Configuration qiniuConfig(QiNiuConfig qiNiuConfig) {
        Region region;
        switch (qiNiuConfig.getRegionId()) {
            case "z0": {
                region = Region.region1();
                break;
            }
            case "z1": {
                region = Region.region1();
                break;
            }
            case "na0": {
                region = Region.regionNa0();
                break;
            }
            case "as0": {
                region = Region.regionAs0();
                break;
            }
            case "fog-cn-east-1": {
                region = Region.regionFogCnEast1();
                break;
            }
            case "cn-east-2": {
                region = Region.regionCnEast2();
                break;
            }
            default: {
                region = Region.region2();
            }
        }
        return new Configuration(region);
    }

    private static UploadManager uploadManager(QiNiuConfig fileConfig) {
        return new UploadManager(QiNiuUtils.qiniuConfig(fileConfig));
    }

    private static UploadManager uploadManager(Configuration configuration) {
        return new UploadManager(configuration);
    }

    private static Auth auth(QiNiuConfig fileConfig) {
        return Auth.create((String)fileConfig.getAccessKey(), (String)fileConfig.getSecretKey());
    }

    private static BucketManager bucketManager(QiNiuConfig fileConfig) {
        return new BucketManager(QiNiuUtils.auth(fileConfig), QiNiuUtils.qiniuConfig(fileConfig));
    }

    private static BucketManager bucketManager(Auth auth, Configuration qiniuConfig) {
        return new BucketManager(auth, qiniuConfig);
    }

    public static void deleteQiNiuClient(Long fileStorageId) {
        try {
            OssCache.qiNiuClientCache.remove(fileStorageId);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u4e03\u725b client cache \u5931\u8d25 fileStorageId {}", (Object)fileStorageId, (Object)e);
        }
    }
}

