/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.cat.file.sdk.core.qiniu;

import cn.tannn.cat.file.sdk.OssOperateAPI;
import cn.tannn.cat.file.sdk.api.UploadFile;
import cn.tannn.cat.file.sdk.bean.FileIndex;
import cn.tannn.cat.file.sdk.bean.FileStorage;
import cn.tannn.cat.file.sdk.config.QiNiuConfig;
import cn.tannn.cat.file.sdk.core.OssCache;
import cn.tannn.cat.file.sdk.core.qiniu.QiNiuClient;
import cn.tannn.cat.file.sdk.core.qiniu.QiNiuUtils;
import cn.tannn.cat.file.sdk.exception.FileException;
import cn.tannn.cat.file.sdk.utils.AboutFileUtil;
import cn.tannn.cat.file.sdk.utils.ResponseFile;
import com.alibaba.fastjson2.JSONReader;
import com.qiniu.http.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class QiNiuOperate
implements OssOperateAPI {
    private static final Logger log = LoggerFactory.getLogger(QiNiuOperate.class);

    @Override
    public FileIndex uploadFile(UploadFile upload, FileStorage storage) throws IOException {
        QiNiuConfig qiNiuConfig = (QiNiuConfig)storage.getConfig().toJavaObject(QiNiuConfig.class, new JSONReader.Feature[0]);
        QiNiuClient qiNiuClient = OssCache.qiNiuClientCache.get(storage.getId());
        String originalName = upload.getFile().getOriginalFilename();
        if (originalName == null) {
            originalName = UUID.randomUUID().toString();
        }
        String suffixDot = AboutFileUtil.getFileSuffixDot(originalName);
        String freshName = StringUtils.isNotBlank((CharSequence)upload.getFileName()) ? upload.getFileName().trim() + suffixDot : originalName;
        String childFolder = Objects.isNull(upload.getChildFolder()) ? "" : upload.getChildFolder();
        String uploadPath = childFolder + freshName;
        String url = qiNiuConfig.getBrowseUrl() + "/" + uploadPath;
        Response response = qiNiuClient.getUploadManager().put(upload.getFile().getInputStream(), uploadPath, QiNiuUtils.getUploadToken(upload.getBucket(), qiNiuClient.getAuth()), null, null);
        log.debug("\u4e03\u725b\u6587\u4ef6\u4e0a\u6b21\u8fd4\u56de\u5185\u5bb9 ===> {}", (Object)response);
        FileIndex fileStorage = new FileIndex();
        fileStorage.setStorageId(storage.getId());
        fileStorage.setStorage(storage.getStorage());
        fileStorage.setOriginalName(originalName);
        fileStorage.setFreshName(freshName);
        fileStorage.setPath(uploadPath);
        fileStorage.setUrl(url);
        fileStorage.setUrlSuffix(uploadPath);
        fileStorage.setBucket(upload.getBucket());
        fileStorage.setType(upload.getFile().getContentType());
        fileStorage.setSizeUnit(AboutFileUtil.getFileSizeUnit(upload.getFile().getSize()));
        fileStorage.setSize(String.valueOf(upload.getFile().getSize()));
        return fileStorage;
    }

    @Override
    public boolean removeFile(FileIndex index) {
        try {
            OssCache.qiNiuClientCache.get(index.getStorageId()).getBucketManager().delete(index.getBucket(), index.getPath());
            return true;
        }
        catch (Exception e) {
            log.error("\u4e03\u725b\u5220\u9664\u5931\u8d25\uff1aindex id : {} , URL: {}", new Object[]{index.getId(), index.getUrl(), e});
            throw new FileException("\u6587\u4ef6\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public void downloadFile(HttpServletResponse response, FileIndex index) {
        QiNiuClient qiNiuClient = OssCache.qiNiuClientCache.get(index.getStorageId());
        String urlString = URLEncoder.encode(index.getPath(), "UTF-8").replaceAll("\\+", "%20");
        String downLoadStr = index.getUrl().replaceAll(index.getPath(), urlString);
        String downloadRUL = qiNiuClient.getAuth().privateDownloadUrl(downLoadStr, 3600L);
        try {
            URL url = new URL(downloadRUL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            HttpServletResponse downResponse = ResponseFile.customResponse(response, index.getType(), index.getFreshName());
            downResponse.setHeader("Content-Length", String.valueOf(index.getSize()));
            IOUtils.copy((InputStream)conn.getInputStream(), (OutputStream)downResponse.getOutputStream());
        }
        catch (Exception e) {
            log.error("\u4e03\u725b\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1aindex id : {} , URL: {}", new Object[]{index.getId(), index.getUrl(), e});
        }
    }
}

