/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.cat.file.sdk.core.minio;

import cn.tannn.cat.file.sdk.bean.FileStorage;
import cn.tannn.cat.file.sdk.config.MinioConfig;
import cn.tannn.cat.file.sdk.core.OssCache;
import cn.tannn.cat.file.sdk.exception.FileException;
import com.alibaba.fastjson2.JSONReader;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.RemoveBucketArgs;
import io.minio.SetBucketPolicyArgs;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.messages.Bucket;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioUtils {
    private static final Logger log = LoggerFactory.getLogger(MinioUtils.class);

    public static void createMinioClient(FileStorage fileStorage) {
        try {
            MinioConfig minio = (MinioConfig)fileStorage.getConfig().toJavaObject(MinioConfig.class, new JSONReader.Feature[0]);
            if (Objects.nonNull(minio)) {
                MinioClient minioClient = MinioUtils.createMinioClient(minio);
                OssCache.minioClientCache.put(fileStorage.getId(), minioClient);
            }
        }
        catch (Exception e) {
            log.error("minio\u300a" + fileStorage.getName() + "\u300b\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5", (Throwable)e);
        }
    }

    public static MinioClient createMinioClient(MinioConfig minio) {
        MinioClient minioClient = minio.getPort() == null ? MinioClient.builder().endpoint(minio.getUploadUrl()).credentials(minio.getAccessKey(), minio.getSecretKey()).build() : MinioClient.builder().endpoint(minio.getUploadUrl(), minio.getPort().intValue(), minio.getHttps().booleanValue()).credentials(minio.getAccessKey(), minio.getSecretKey()).build();
        return minioClient;
    }

    public static MinioClient getMinioClient(Long fileStorageId) {
        MinioClient minioClient = OssCache.minioClientCache.get(fileStorageId);
        if (minioClient == null) {
            throw new FileException("minio\u914d\u7f6e\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u6dfb\u52a0");
        }
        return minioClient;
    }

    public static void deleteMinioClient(Long fileStorageId) {
        try {
            OssCache.minioClientCache.remove(fileStorageId);
        }
        catch (Exception e) {
            log.error("\u5220\u9664minio client cache \u5931\u8d25 fileStorageId {}", (Object)fileStorageId, (Object)e);
        }
    }

    public static boolean bucketExists(Long fileStorageId, String bucket) throws Exception {
        MinioClient minioClient = MinioUtils.getMinioClient(fileStorageId);
        return minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucket)).build());
    }

    public static void makeBucket(Long fileStorageId, String bucket) {
        try {
            boolean found = MinioUtils.bucketExists(fileStorageId, bucket);
            if (!found) {
                MinioClient minioClient = MinioUtils.getMinioClient(fileStorageId);
                minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucket)).build());
                String str = " {\n     \"Statement\": [\n         {\n             \"Action\": [\n                 \"s3:GetBucketLocation\",\n                 \"s3:ListBucket\"\n             ],\n             \"Effect\": \"Allow\",\n             \"Principal\": \"*\",\n             \"Resource\": \"arn:aws:s3:::" + bucket + "\"\n         },\n         {\n             \"Action\": \"s3:GetObject\",\n             \"Effect\": \"Allow\",\n             \"Principal\": \"*\",\n             \"Resource\": \"arn:aws:s3:::" + bucket + "/*\"\n         }\n     ],\n     \"Version\": \"2012-10-17\"\n }";
                minioClient.setBucketPolicy((SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().bucket(bucket)).config(str).build());
            }
        }
        catch (Exception e) {
            throw new FileException("minio\u6876\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u68c0\u6d4b\u914d\u7f6e\u8d26\u6237\u65f6\u5019\u6709\u6743\u9650! ", e);
        }
    }

    public static List<Bucket> listBuckets(Long fileStorageId) throws Exception {
        MinioClient minioClient = MinioUtils.getMinioClient(fileStorageId);
        return minioClient.listBuckets();
    }

    public static void removeBucket(Long fileStorageId, String bucketName) throws Exception {
        MinioClient minioClient = MinioUtils.getMinioClient(fileStorageId);
        minioClient.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
    }

    public static StatObjectResponse statObject(Long fileStorageId, String bucket, String objectName) throws Exception {
        boolean found = MinioUtils.bucketExists(fileStorageId, bucket);
        if (!found) {
            throw new FileException("\u6876\u4e0d\u5b58\u5728\uff01");
        }
        return MinioUtils.getMinioClient(fileStorageId).statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucket)).object(objectName)).build());
    }

    public static InputStream fileInputStream(Long fileStorageId, String bucket, String objectName) throws Exception {
        boolean found = MinioUtils.bucketExists(fileStorageId, bucket);
        if (!found) {
            throw new FileException("\u6876\u4e0d\u5b58\u5728\uff01");
        }
        return MinioUtils.getMinioClient(fileStorageId).getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucket)).object(objectName)).build());
    }
}

