/*
 * Decompiled with CFR 0.152.
 */
package cn.tannn.cat.file.sdk.core.local;

import cn.tannn.cat.file.sdk.OssOperateAPI;
import cn.tannn.cat.file.sdk.api.UploadFile;
import cn.tannn.cat.file.sdk.bean.FileIndex;
import cn.tannn.cat.file.sdk.bean.FileStorage;
import cn.tannn.cat.file.sdk.config.LocalConfig;
import cn.tannn.cat.file.sdk.core.local.LocalDirverUtil;
import cn.tannn.cat.file.sdk.exception.FileException;
import cn.tannn.cat.file.sdk.utils.AboutFileUtil;
import cn.tannn.cat.file.sdk.utils.ResponseFile;
import com.alibaba.fastjson2.JSONReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class LocalOperate
implements OssOperateAPI {
    private static final Logger log = LoggerFactory.getLogger(LocalOperate.class);
    public static final String SPIRIT = "/";
    @Value(value="${server.port:8080}")
    private int serverPort;
    @Value(value="${server.servlet.context-path:/}")
    private String serverName;
    @Value(value="${server.servlet.context-path:/}")
    private String prefix;

    @Override
    public FileIndex uploadFile(UploadFile upload, FileStorage storage) throws IOException {
        String diskPathBucket;
        LocalConfig localConfig = (LocalConfig)storage.getConfig().toJavaObject(LocalConfig.class, new JSONReader.Feature[0]);
        MultipartFile file = upload.getFile();
        String originalName = file.getOriginalFilename();
        if (originalName == null) {
            throw new FileException("\u6587\u4ef6\u6709\u95ee\u9898\uff0cOriginalFilename \u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        String suffixDot = AboutFileUtil.getFileSuffixDot(originalName);
        String freshName = StringUtils.isNotBlank((CharSequence)upload.getFileName()) ? upload.getFileName().trim() + suffixDot : LocalDirverUtil.encrypt2MD5(originalName) + suffixDot;
        String childFolder = Objects.isNull(upload.getChildFolder()) ? "" : upload.getChildFolder();
        String diskPathLast = childFolder + freshName;
        String urlSuffix = diskPathBucket = upload.getBucket() + SPIRIT + diskPathLast;
        File dest = new File(localConfig.getUploadDir() + SPIRIT + urlSuffix);
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }
        file.transferTo(dest);
        String contextPath = LocalDirverUtil.contextPath(localConfig.getContextPath());
        if (StringUtils.isNotBlank((CharSequence)contextPath)) {
            urlSuffix = contextPath.substring(0, contextPath.lastIndexOf(SPIRIT) + 1) + urlSuffix;
        }
        if (!SPIRIT.equals(this.prefix)) {
            urlSuffix = this.prefix + urlSuffix;
        }
        String url = this.getBrowserUrl(localConfig.getBrowseUrl()) + urlSuffix;
        FileIndex fileStorage = new FileIndex();
        fileStorage.setStorageId(storage.getId());
        fileStorage.setStorage(storage.getStorage());
        fileStorage.setOriginalName(originalName);
        fileStorage.setFreshName(freshName);
        String diskPath = localConfig.getUploadDir() + SPIRIT + diskPathBucket;
        fileStorage.setPath(diskPath);
        fileStorage.setUrl(url);
        fileStorage.setUrlSuffix(urlSuffix);
        fileStorage.setBucket(upload.getBucket());
        fileStorage.setType(upload.getFile().getContentType());
        fileStorage.setSizeUnit(AboutFileUtil.getFileSizeUnit(upload.getFile().getSize()));
        fileStorage.setSize(String.valueOf(upload.getFile().getSize()));
        return fileStorage;
    }

    @Override
    public boolean removeFile(FileIndex index) {
        try {
            File file = new File(index.getPath());
            return file.delete();
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff1aindex id : {} , URL: {}", new Object[]{index.getId(), index.getUrl(), e});
            throw new FileException("\u6587\u4ef6\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public void downloadFile(HttpServletResponse response, FileIndex index) {
        File file = new File(index.getPath());
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            HttpServletResponse downResponse = ResponseFile.fileResponse(response, file);
            IOUtils.copy((InputStream)in, (OutputStream)downResponse.getOutputStream());
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1aindex id : {} , URL: {}", new Object[]{index.getId(), index.getUrl(), e});
        }
    }

    private String getBrowserUrl(String browseUrl) {
        if (StringUtils.isBlank((CharSequence)browseUrl)) {
            if (SPIRIT.equals(this.serverName)) {
                this.serverName = "";
            }
            browseUrl = "http://" + LocalDirverUtil.getRealIp() + ":" + this.serverPort + this.serverName;
        }
        return browseUrl;
    }
}

