/*
 * Decompiled with CFR 0.152.
 */
package cn.tangjiabin.pft.soap.strategy;

import cn.tangjiabin.pft.config.PFTConfig;
import cn.tangjiabin.pft.model.response.Data;
import cn.tangjiabin.pft.soap.SoapStrategy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DefaultSoapStrategy<T, R>
implements SoapStrategy<T, R> {
    @Override
    public SOAPMessage createRequest(String methodName, T request, PFTConfig config) throws SOAPException, IllegalAccessException {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage soapMessage = messageFactory.createMessage();
        SOAPPart soapPart = soapMessage.getSOAPPart();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        SOAPBody soapBody = envelope.getBody();
        SOAPElement soapBodyElem = soapBody.addChildElement(methodName);
        soapBodyElem.addChildElement("ac").addTextNode(config.getAc());
        soapBodyElem.addChildElement("pw").addTextNode(config.getPw());
        Field[] fields = request.getClass().getDeclaredFields();
        Arrays.sort(fields, Comparator.comparingInt(field -> {
            try {
                return field.getDeclaringClass().getDeclaredField(field.getName()).getModifiers();
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }));
        for (Field field2 : fields) {
            field2.setAccessible(true);
            soapBodyElem.addChildElement(field2.getName()).addTextNode(String.valueOf(field2.get(request)));
        }
        soapMessage.saveChanges();
        return soapMessage;
    }

    @Override
    public Data<R> parseResponse(SOAPMessage response, String responseTag, Class<R> clazz) throws Exception {
        ArrayList<R> recs = new ArrayList<R>();
        SOAPBody soapBody = response.getSOAPBody();
        SOAPElement responseElement = (SOAPElement)soapBody.getElementsByTagName(responseTag).item(0);
        String nestedXmlString = responseElement.getTextContent().trim();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new ByteArrayInputStream(nestedXmlString.getBytes()));
        NodeList recList = document.getElementsByTagName("Rec");
        for (int i = 0; i < recList.getLength(); ++i) {
            Element recElement = (Element)recList.item(i);
            NodeList errorCode = recElement.getElementsByTagName("UUerrorcode");
            NodeList errorInfo = recElement.getElementsByTagName("UUerrorinfo");
            if (errorCode.getLength() > 0 && errorInfo.getLength() > 0) {
                String code = errorCode.item(0).getTextContent();
                String info = errorInfo.item(0).getTextContent();
                return new Data(code, info);
            }
            int size = 0;
            Field[] fields = clazz.getDeclaredFields();
            if (fields.length > 0) {
                String name = fields[0].getName();
                NodeList nodeList = recElement.getElementsByTagName(name);
                size = nodeList.getLength();
            }
            for (int j = 0; j < size; ++j) {
                R rec = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (Field field : clazz.getDeclaredFields()) {
                    String tagName = field.getName();
                    NodeList nodeList = recElement.getElementsByTagName(tagName);
                    if (nodeList.getLength() <= 0) continue;
                    String value = nodeList.item(j).getTextContent();
                    field.setAccessible(true);
                    field.set(rec, value);
                }
                recs.add(rec);
            }
        }
        return new Data(recs);
    }

    private static void printMessage(SOAPMessage response) throws SOAPException, IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        response.writeTo((OutputStream)os);
        String output = ((Object)os).toString();
        String escapedOutput = output.replaceAll("&amp;", "&").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&apos;", "'");
        System.out.println();
        System.out.println("==============================");
        System.out.println();
        System.out.println(escapedOutput);
        System.out.println();
        System.out.println("==============================");
        System.out.println();
    }
}

