package cn.tangjiabao.halodb.utils.sql;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

/**
 * 填充sql
 *
 * @author von_change@163.com
 * @date 2016年4月6日 下午6:07:00
 * @since 1.0
 */
public class HSqlFill {
	 private static String getParameterValue(Object obj) {
	      String value = null;
	      if (obj instanceof String) {
	          value = "'" + obj.toString() + "'";
	      } else if (obj instanceof Date) {
	          DateFormat formatter = DateFormat.getDateTimeInstance(DateFormat.DEFAULT, DateFormat.DEFAULT, Locale.CHINA);
	          value = "'" + formatter.format(new Date()) + "'";
	      } else {
	          if (obj != null) {
	              value = obj.toString();
	          } else {
	              value = "";
	          }

	      }
	      return value;
	  }
	  public static String fill(String source,Object[] params) {
		    String sql = source.replaceAll("[\\s]+", " ");
		    for (Object object : params) {
		    	sql = sql.replaceFirst("\\?", getParameterValue(object));
			}
			return sql;
	  }
	  public static void main(String[] args) {
		String sql="select * from User where userId=? and   name      like ? and abc=?";
		String result=HSqlFill.fill(sql, new Object[]{1,"上的动点",new Date()});
		
		System.out.println(HSQLFormatter.format(result));
	}
}
