package cn.tangjiabao.halodb.utils.orm;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import cn.tangjiabao.halodb.core.bean.SelectColumn;
import cn.tangjiabao.halodb.core.constant.HaloConstant;
import cn.tangjiabao.halodb.utils.file.HFileUtils;
import cn.tangjiabao.halodb.utils.logger.HLogUtils;
import cn.tangjiabao.halodb.utils.map.HHashMap;
import cn.tangjiabao.halodb.utils.orm.impl.OrmImpl;
import cn.tangjiabao.halodb.utils.orm.impl.OrmImplNot;
import cn.tangjiabao.halodb.utils.string.HStringUtils;
import cn.tangjiabao.halodb.utils.xml.HXmlUtils;

/**
 * Orm组件
 * 
 * @author von_change@163.com
 * @date 2015-6-14 下午1:02:52
 */
public class HOrmUtil {
	private static final Log logger = LogFactory.getLog(HOrmUtil.class);
	/**
	 * _转大写
	 * 
	 * @param value
	 */
	public static String toUp(String value) {
		StringBuffer sb = new StringBuffer();
		boolean flag = false;
		for (int i = 0; i < value.length(); i++) {
			char cur = value.charAt(i);
			if (cur == '_') {
				flag = true;

			} else {
				if (flag) {
					sb.append(Character.toUpperCase(cur));
					flag = false;
				} else {
					sb.append(cur);
				}
			}
		}
		return sb.toString();
	}

	private static boolean getSqlIsOrm() {
		File xmlPath = HFileUtils.getClassPathNull("", "halo-config.xml");
		if (null == xmlPath || !xmlPath.exists()) {
			return true;
		}
		HXmlUtils xmlUtils = new HXmlUtils(xmlPath);
		return xmlUtils.sqlIsOrm();
	}

	private static IOrm getOrm() {
		boolean flag = getSqlIsOrm();
		if (flag) {
			return new OrmImpl();
		}
		if (!flag) {
			return new OrmImplNot();
		}
		return new OrmImpl();
	}

	/**
	 * 数据库字段名转实体类字段名
	 * 
	 * @param colName
	 * @return 实体类字段名
	 */
	public static String toFiled(String colName) {
		IOrm orm = getOrm();
		return orm.toFiled(colName);
	}

	/**
	 * Hql转成sql
	 * 
	 * @param myHql
	 * @return sql
	 */
	public static String toSql(String myHql) {
		IOrm orm = getOrm();
		return orm.toSql(myHql);
	}

	/**
	 * 数据库表名转实体名
	 * 
	 * @param tableName
	 * @return 实体名
	 */
	public static String toEntity(String tableName) {
		StringBuffer sb = new StringBuffer();
		boolean flag = false;
		for (int i = 0; i < tableName.length(); i++) {
			char cur = tableName.charAt(i);
			if (cur == '_') {
				flag = true;

			} else {
				if (flag) {
					sb.append(Character.toUpperCase(cur));
					flag = false;
				} else {
					sb.append(Character.toLowerCase(cur));
				}

			}
		}
		return HStringUtils.capitalize(sb.toString());
	}
	/**
	 * 从sql语句中获得alias
	 * 
	 * @param sqlFragment
	 * @return Map
	 */
	public static Map<String, Boolean> getAliasFromSql(String sqlFragment) {
		Map<String, Boolean> aliasMap = new HHashMap<String, Boolean>();
		Matcher m = Pattern.compile("([\\w]*\\.[\\w]*)").matcher(sqlFragment);
		while (m.find()) {
			String group = m.group();
			if (!group.startsWith("t.")) {
				String aliasStr = HStringUtils.substringBefore(group, ".");
				aliasMap.put(aliasStr, false);
			}
		}
		return aliasMap;
	}

	/**
	 * 分析查询字段语句
	 * 
	 * @param columnStr
	 * @return SelectColumn
	 */
	public static SelectColumn analyzeSelectColumn(String columnStr) {
		SelectColumn selectColumn = new SelectColumn();
		selectColumn.setOrgColumnSql(columnStr);
		HHashMap<String, Boolean> aliasMap = new HHashMap<String, Boolean>();
		Matcher mas = Pattern.compile("(as[ ]*[\\w]*\\.[\\w]*)").matcher(columnStr);
		while (mas.find()) {
			String group = mas.group();
			String repalceStr = group.replace(".", HaloConstant.DIANINALIAS);
			if (!repalceStr.equals(group)) {
				columnStr = columnStr.replace(group, repalceStr);
			}
		}
		Matcher m = Pattern.compile("([\\@\\w]*\\.[\\w]*)").matcher(columnStr);
		List<String> patternListW = new ArrayList<String>();
		List<String> replaceStrListW = new ArrayList<String>();
		while (m.find()) {
			String group = m.group();
			StringBuffer repalceStr = new StringBuffer();
			if (!group.startsWith("t.")) {
				String aliasStr = HStringUtils.substringBefore(group, ".");
				aliasMap.set(aliasStr, false);
				String alias = group.replace(".", HaloConstant.DIANINALIAS);
				repalceStr.append(group).append(" as ").append(alias);
				if (group.startsWith("@")) {
					repalceStr = new StringBuffer();
					repalceStr.append(group.substring(1));
				}
				patternListW.add(group);
				replaceStrListW.add(repalceStr.toString());
			}
		}
		columnStr = HStringUtils.replaceEach(columnStr, patternListW.toArray(new String[patternListW.size()]), replaceStrListW.toArray(new String[replaceStrListW.size()]));
		selectColumn.setCookedColumnSql(columnStr);
		selectColumn.setAliasMap(aliasMap);
		logger.debug(HLogUtils.format("字段sql", columnStr));
		return selectColumn;
	}

}
