package cn.tangjiabao.halodb.utils.file;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

import cn.tangjiabao.halodb.core.exception.MyRuntimeException;
import cn.tangjiabao.halodb.utils.classloader.HClassLoaderUtils;
import cn.tangjiabao.halodb.utils.string.HStringUtils;

/**
 * 文件组件
 * @author von_change@163.com
 * @date 2015-6-14 下午10:33:39
 */
public class HFileUtils  {
	private static final String ENCODING = "UTF-8";
	public static  String  URLSEPARATOR="/";
	public static String getEncoding() {
		return ENCODING;
	}
	private static String getFileURLPath(String packageName, String name) {
		String path = packageName.replaceAll("\\.", URLSEPARATOR);
		return  path + URLSEPARATOR+ name;//"/" +path=URLDecoder.decode(path,ENCODING);
	}

	public static File getClassPath(String packageName, String name) {
	    File file = null;
		try {
			file = HClassLoaderUtils.getResourceAsFile(getFileURLPath(packageName, name));
		} catch (IOException e) {
			e.printStackTrace();
		}
		return file;
	}
	public static File getClassPathNull(String packageName, String name)  {
	    File file;
		try {
			file = HClassLoaderUtils.getResourceAsFile(getFileURLPath(packageName, name));
		} catch (IOException e) {
			return null;
		}
		return file;
	}
	/**
	 * 获得类文件
	 * @param clazz
	 * @return File
	 */
	public static File getClassPath(Class<?> clazz) {
		String className=clazz.getSimpleName()+".class";
		String path =clazz.getResource(className).getPath();
		try {
			path=URLDecoder.decode(path,ENCODING);
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		File file = new File(path);
		return file;
	}
	public static File getClassPathByClazz(Class<?> clazz,String fileName) {
		URL pathUrl =clazz.getResource(fileName);
		if(null==pathUrl){
			throw MyRuntimeException.Instance(fileName,"文件不存在！");
		}
		String path=pathUrl.getPath();
		try {
			path=URLDecoder.decode(path,ENCODING);
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		File file = new File(path);
		return file;
	}
	/**
     * 过滤输出文件:如果没有路径文件夹 创建之
	 * @param outFile
	 * @return  File
	 */
	public static File newOutFile(File outFile) {
		return createFolder(outFile);
	}

	public static File newOutFile(String outfilePath) {
		return createFolder(new File(outfilePath));
	}

	public static File createFolder(File targetFile) {
		String path = targetFile.getAbsolutePath();
		String folder = HStringUtils.substringBefore(path, targetFile.getName());
		File folderFile = new File(folder);
		if (!folderFile.exists()) {
			folderFile.mkdirs();
		}
		return targetFile;
	}

	/**
	 * 创建文件夹
	 * @param folderPath
	 */
	public static void newFolder(String folderPath) {
		try {
			File folder = new File(folderPath);
			if (!folder.exists()) {
				folder.mkdir();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * 创建并获得路径
	 * @param folderPath
	 * @return folderPath
	 */
	public static String getFolderPath(String folderPath) {
		File folder = null;
		try {
			folder = new File(folderPath);
			if (!folder.exists()) {
				folder.mkdirs();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		if(null==folder){
			return null;
		}
		return folder.getAbsolutePath();
	}

	/**
	 *  取指定文件的扩展名
	 * @param filePathName
	 *            文件路径
	 * @return 扩展名
	 */
	public static String getFileExt(String filePathName) {
		int pos = 0;
		pos = filePathName.lastIndexOf('.');
		if (pos != -1)
			return filePathName.substring(pos + 1, filePathName.length());
		else
			return "";
	}

}
