package cn.tangjiabao.halodb.core.page;

import java.util.Collection;
import java.util.Iterator;

/**
 * 分页接口
 * @author von_change@163.com
 * @date 2015-6-14 下午1:01:00
 * @param <T>
 */
public interface IPage<T> {

	/**
	 * 返回每一页的大小，即每页的记录数。
	 */
	public int getPageSize() ;

	/**
	 * 返回要提取的页的序号，该序号是从1开始计算的。
	 */
	public int getPageNo() ;

	/**
	 * 返回当前页中第一条记录对应的序号，该序号是从0开始计算的。<br>
	 * 注意，此处在计算firstEntityIndex是不考虑实际提取过程中当前页是否存在的。
	 */
	public int getFirstEntityIndex() ;

	/**
	 * 返回当前页中最后一条记录对应的序号，该序号是从0开始计算的。<br>
	 * 注意，此处在计算lastEntityIndex是不考虑实际提取过程中当前页是否存在或者记录数是否可达到pageSize的。
	 */
	public int getLastEntityIndex() ;

	/**
	 * 设置当页数据。
	 */
	public void setEntities(Collection<T> entities) ;

	/**
	 * 返回当页数据。
	 */
	public Collection<T> getEntities() ;

	/**
	 * 设置总记录数。
	 * <p>
	 * 此处的总记录数并不是指当页数据的总数，而是指整个结果的总数。 即每一页数据累计的总数。
	 * </p>
	 */
	public int getEntityCount() ;

	/**
	 * 返回总记录数。
	 * <p>
	 * 此处的总记录数并不是指当页数据的总数，而是指整个结果的总数。即每一页数据累计的总数。
	 * </p>
	 */
	public void setEntityCount(int entityCount) ;

	/**
	 * 返回总的记录页数。
	 */
	public int getPageCount() ;
	
	
	/**
	 * Returns whether the current page is the first one.
	 * 
	 * @return
	 */
	boolean isFirstPage();
	/**
	 * Returns whether the current page is the last one.
	 * 
	 * @return
	 */
	boolean isLastPage();
	

	/**
	 * 返回当页数据的迭代器。
	 */
	public Iterator<T> iterator() ;
}
