package cn.tangjiabao.halodb.utils.named;
import java.util.ArrayList;
import java.util.List;

/**
 * 此类封装NamedParameterSql
 */
public class ParsedSql {
	
	private String originalSql;
	//参数名
	private List<String> paramNames = new ArrayList<String>();
	//参数在sql中对应的位置
	private List<int[]> paramIndexs = new ArrayList<int[]>();
	//统计参数个数（不包含重复）
	private int namedParamCount;
	//统计sql中？的个数
	private int unnamedParamCount;
	
	private int totalParamCount;
	
	public ParsedSql(String originalSql){
		this.originalSql = originalSql;
	}
	
	public List<String> getParamNames() {
		return paramNames;
	}

	public void addParamNames(String paramName,int startIndex,int endIndex) {
		paramNames.add(paramName);
		paramIndexs.add(new int[]{startIndex,endIndex});
	}

	public int[] getParamIndexs(int position) {
		return paramIndexs.get(position);
	}


	public String getOriginalSql() {
		return originalSql;
	}

	
	public int getNamedParamCount() {
		return namedParamCount;
	}

	public void setNamedParamCount(int namedParamCount) {
		this.namedParamCount = namedParamCount;
	}

	public int getUnnamedParamCount() {
		return unnamedParamCount;
	}

	public void setUnnamedParamCount(int unnamedParamCount) {
		this.unnamedParamCount = unnamedParamCount;
	}

	public int getTotalParamCount() {
		return totalParamCount;
	}

	public void setTotalParamCount(int totalParamCount) {
		this.totalParamCount = totalParamCount;
	}

	public String toString(){
		return this.originalSql;
	}

}

