package cn.tangjiabao.halodb.utils.logger;

/**
 * 日志组件
 * @author von_change@163.com
 * @date 2015-6-14 下午10:36:14
 */
public class HLogUtils {

	/**
	 * 美化日志输出
	 * @param message
	 * @return Object
	 */
	public static String format(Object... message) {
		StringBuffer sb = new StringBuffer();
		for (Object object : message) {
			sb.append("\n").append(String.valueOf(object));
		}
		return sb.toString();
	}

	/**
	 * 简单美化输出
	 * @param info
	 * @param message
	 * @return Object
	 */
	public static String formatOL(String info, Object message) {
		StringBuffer sb = new StringBuffer();
		sb.append("\n").append(info).append(":::").append(String.valueOf(message));
		return sb.toString();
	}

	/**
	 *  输出数组
	 * @param info
	 * @param attr
	 * @return Object
	 */
	public static String attr(String info, Object[] attr) {
		StringBuffer sb = new StringBuffer();
		sb.append("\n").append(info).append("\n");
		for (Object object : attr) {
			sb.append(String.valueOf(object)).append(";");
		}
		return sb.toString();
	}
}
