package cn.tangjiabao.halodb.utils.convert;

import java.math.BigDecimal;
import java.util.Date;

import jodd.typeconverter.Convert;

/**
 * TODO 简单方式(效率高)实现类型转换,细节部分会不如ConvertUtils :ConvertUtils一次类型转换需要69ms 有点代价过高
 * 不过多个也大概是这个时间?
 * 
 * @author von_change@163.com
 * @date 2015-1-26 下午3:27:13
 */
public class HConvertUtils  extends jodd.typeconverter.Convert{
	private static String NULLSTR="NULL";
   private static Object toNull(Object value){
	   if(null==value){
		   return null;
	   }
	   if(value instanceof String){
		   if(NULLSTR.equals(value)){
			   return null;
		   }
	   }
	   return value;
   }
	public static Integer toInteger(Object value) {
		value=toNull(value);
		return Convert.toInteger(value);
	}

	public static String toString(Object value) {
		value=toNull(value);
		return Convert.toString(value);
	}

	public static Long toLong(Object value) {
		value=toNull(value);
		return Convert.toLong(value);
	}

	public static Boolean toBoolean(Object value) {
		value=toNull(value);
		return Convert.toBoolean(value);
	}

	public static Double toDouble(Object value) {
		value=toNull(value);
		return Convert.toDouble(value);
	}


	public static Float toFloat(Object value) {
		value=toNull(value);
		return Convert.toFloat(value);
	}

	public static Short toShort(Object value) {
		value=toNull(value);
		return Convert.toShort(value);
	}


	public static Byte toByte(Object value) {
		value=toNull(value);
		return Convert.toByte(value);
	}

	public static BigDecimal toBigDecimal(String value) {
		if (null == value) {
			return null;
		}
		value = value.trim();
		if ("null".equals(value)) {
			return null;
		}
		return new BigDecimal(value);
	}
	public static Date toDate(Object value) {
		value=toNull(value);
		return Convert.toDate(value);
	}

	public static BigDecimal toBigDecimal(Object value) {
		value=toNull(value);
		return Convert.toBigDecimal(value);
	}

	public static Object toObject(Object value, Class<?> targetType) {
		if (null == value) {
			return null;
		}
		if (value.getClass().getName().equals(targetType.getName())) {
			return value;
		}
		String targetTypeName = targetType.getSimpleName();
		if (targetTypeName.equals("string")) {
			return HConvertUtils.toString(value);
		}
		if (targetTypeName.equals("Integer")) {
			return HConvertUtils.toInteger(value);
		}
		if (targetTypeName.equals("Long")) {
			return HConvertUtils.toLong(value);
		}
		if (targetTypeName.equals("Boolean")) {
			return HConvertUtils.toBoolean(value);
		}
		if (targetTypeName.equals("Float")) {
			return HConvertUtils.toFloat(value);
		}
		if (targetTypeName.equals("Double")) {
			return HConvertUtils.toDouble(value);
		}
		if (targetTypeName.equals("Short")) {
			return HConvertUtils.toShort(value);
		}
		if (targetTypeName.equals("Byte")) {
			return HConvertUtils.toByte(value);
		}
		if (targetTypeName.equals("BigDecimal")) {
			return HConvertUtils.toBigDecimal(value);
		}
		return value;
	}
	
	
}
