package cn.tangjiabao.halodb.core.map;

import java.util.Map;

import cn.tangjiabao.halodb.core.constant.HaloConstant;
import cn.tangjiabao.halodb.utils.map.HHashMap;
import cn.tangjiabao.halodb.utils.map.HLinkedHashMap;

/**
 * 设置查询参数
 * @author fengchangyi
 * @date 2014-11-6 上午9:16:45
 */
public class HaloMap extends HLinkedHashMap<String, Object> implements
		Map<String, Object> {
	private static final long serialVersionUID = -6169144882263038794L;
	private String select;//原columnSql xml中字段ID
	private int addOrder = 0;
	private int addGroup = 0;
	private Map<String,Object> viewParams= new HHashMap<String, Object>();
	private Map<String,Boolean> updateNullMap=new HHashMap<String, Boolean>();
	public HaloMap() {
	}

	/**
	 * 普通map转换到HaloMap
	 * @param map
	 */
	public HaloMap(Map<String, Object> map) {
		if (null == map) {
			map = new HaloMap();
		}
		for (Entry<String, Object> entry : map.entrySet()) {
			this.set(entry.getKey(), entry.getValue());
		}
		// super(map);
	}

	/**
	 * 普通map设置到HaloMap
	 * @param map
	 * @return
	 */
	public HaloMap setAll(Map<String, Object> map) {
		if (null == map) {
			map = new HaloMap();
		}
		for (Entry<String, Object> entry : map.entrySet()) {
			this.set(entry.getKey(), entry.getValue());
		}
		return this;
	}

	/**
	 * 设置参数
	 * @param key
	 * @param value
	 * @return HaloMap
	 */
	public HaloMap set(String key, Object value) {
		if (key.startsWith(HaloConstant.Instruction.ADDORDER)) {
			addOrder++;
			super.put(HaloConstant.Instruction.ADDORDER+ addOrder, value);
			return this;
		}
		if (key.startsWith(HaloConstant.Instruction.ADDGROUP)) {
			addGroup++;
			super.put(HaloConstant.Instruction.ADDGROUP+ addGroup, value);
			return this;
		}
		super.put(key, value);
		return this;
	}

	/**
	 * 设置数组
	 * @param key
	 * @param value
	 * @return HaloMap
	 */
	public HaloMap sets(String key, Object... value) {
		Object valueTemp = value;
		return this.set(key, valueTemp);
	}
	public HaloMap setSql(String sqlId, Object value) {
		return this.set(sqlId+"_sql", value);
	}
	public HaloMap addSql(String sqlId) {
		return this.set(sqlId+"_sql", null);
	}
	/**
	 * 不允许使用！
	 * @param key
	 * @param value
	 * @return null
	 */
	public HaloMap put(String key, Object value) {
		throw new RuntimeException("不允许使用put！！");
	}
	/**
	 * 设置排序参数
	 * @param orders
	 * @return HaloMap
	 */
	public HaloMap addOrder(String... orders) {
		for (String order : orders) {
			this.set(HaloConstant.Instruction.ADDORDER, order);
		}
		return this;
	}
	/**
	 * 设置分组参数
	 * @param groups
	 * @return HaloMap
	 */
	public HaloMap addGroup(String... groups) {
		for (String group : groups) {
			this.set(HaloConstant.Instruction.ADDGROUP, group);
		}
		return this;
	}
	/**
	 * 设置查询结果的开始条数
	 * @param value
	 * @return HaloMap
	 */
	public HaloMap addBegin(Object value) {
		this.set(HaloConstant.Instruction.ADDBEGIN, value);
		return this;
	}

	/**
	 * 设置查询结果的结束条数
	 * @param value
	 * @return HaloMap
	 */
	public HaloMap addEnd(Object value) {
		this.set(HaloConstant.Instruction.ADDEND, value);
		return this;
	}


	public String getSelect() {
		return select;
	}

	/**
	 * 设置columnSql(xml里的columnSql的Id)
	 * @param columnSql
	 * @return HaloMap
	 */
	public HaloMap setSelect(String select) {
		this.select=select;
		return this;
	}

	public Map<String, Object> getViewParams() {
		return viewParams;
	}

	/**
	 * 设置halo视图的参数
	 * @param key
	 * @param value
	 * @return HaloMap
	 */
	public HaloMap setViewParam(String key,Object value) {
		this.viewParams.put(key, value);
		return this;
	}



	public Map<String, Boolean> getUpdateNullMap() {
		return updateNullMap;
	}

	/**
	 * 设置更新为null的字段
	 * @param fieldName
	 * @return
	 */
	public HaloMap setUpdateNullFields(String... fieldName) {
		for (String str : fieldName) {
			this.updateNullMap.put(str, true);
		}		
		return this;
	}

}
