package cn.tangjiabao.halodb.core.map;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

import cn.tangjiabao.halodb.utils.convert.HConvertUtils;
import cn.tangjiabao.halodb.utils.map.HHashMap;
import cn.tangjiabao.halodb.utils.string.HStringUtils;

/**
 *  获取Map,扩展类型转化
 * @author fengchangyi@haitao-tech.com
 * @date 2015-1-12 上午10:51:33
 */
public class HaloGetMap extends HHashMap<String, Object> implements Map<String, Object> {

	/**
	 * @Fields serialVersionUID : TODO
	 */
	private static final long serialVersionUID = 8955941754407113803L;

	public HaloGetMap() {
	}

	public HaloGetMap(Map<String, Object> map) {
		if (null == map) {
			map = new HaloGetMap();
		}
		for (Entry<String, Object> entry : map.entrySet()) {
			this.set(entry.getKey(), entry.getValue());
		}
	}

	public HaloGetMap set(String key, Object value) {
		super.put(key, value);
		return this;
	}

	public HaloGetMap put(String key, Object value) {
		return this.set(key, value);
	}

	private String filterKey(String key) {
		return key.replaceAll("3", "#");
	}

	public Object get(String key) {
		key = filterKey(key);
		if (key.indexOf("#") == -1) {
			return super.get(key);
		}
		if (key.endsWith("#Integer")) {
			key = HStringUtils.substringBefore(key, "#Integer");
			return getInteger(key);
		}
		if (key.endsWith("#Date")) {
			key = HStringUtils.substringBefore(key, "#Date");
			return getDate(key);
		}
		if (key.endsWith("#Double")) {
			key = HStringUtils.substringBefore(key, "#Double");
			return getDouble(key);
		}
		if (key.endsWith("#BigDecimal")) {
			key = HStringUtils.substringBefore(key, "#BigDecimal");
			return getBigDecimal(key);
		}
		if (key.endsWith("#Float")) {
			key = HStringUtils.substringBefore(key, "#Float");
			return getFloat(key);
		}
		if (key.endsWith("#Long")) {
			key = HStringUtils.substringBefore(key, "#Long");
			return getLong(key);
		}
		if (key.endsWith("#Short")) {
			key = HStringUtils.substringBefore(key, "#Short");
			return getShort(key);
		}
		if (key.endsWith("#String")) {
			key = HStringUtils.substringBefore(key, "#String");
			return getString(key);
		}

		return super.get(key);
	}

	public Integer getInteger(String key) {
		Object value = super.get(key);
		return HConvertUtils.toInteger(value);
	}

	public Date getDate(String key) {
		Object value = super.get(key);
		return  HConvertUtils.toDate(value);
	}

	public Boolean getBoolean(String key) {
		Object value = super.get(key);
		return HConvertUtils.toBoolean(value);
	}

	public BigDecimal getBigDecimal(String key) {
		Object value = super.get(key);
		return HConvertUtils.toBigDecimal(value);
	}

	public Double getDouble(String key) {
		Object value = super.get(key);
		return  HConvertUtils.toDouble(value);
	}

	public Float getFloat(String key) {
		Object value = super.get(key);
		return HConvertUtils.toFloat(value);
	}

	public Short getShort(String key) {
		Object value = super.get(key);
		return HConvertUtils.toShort(value);
	}

	public Long getLong(String key) {
		Object value = super.get(key);
		return  HConvertUtils.toLong(value);
	}

	public String getString(String key) {
		Object value = super.get(key);
		return  HConvertUtils.toString(value);
	}

}
