package cn.tangjiabao.halodb.core.enums;

import java.util.Arrays;

/**
 *条件枚举
 * @author von_change@163.com
 * @date 2015-6-14 下午12:48:41
 */
public enum SearchOperator {
	eq("等于", "eq","="), neq("不等于", "neq","<>"), gt("大于","gt",">"), 
	ge("大于等于", "ge",">="), lt("小于","lt", "<"), le("小于等于", "le","<="), 
	like("模糊匹配","like","like"), notLike("模糊不匹配", "notLike","not like"), 
	isNull("空","isNull", "is null"), isNotNull("非空","isNotNull","is not null"), 
	in("包含", "in","in"), notIn("不包含", "notIn","not in"), not("不为","not","<>"),
	between("在之间","between","between"),
	sql("xml里的sql","sql","sql"),
	custom("自定义默认的", null,null);
	private final String desc;
	private final String ad;
	private final String symbol;

	SearchOperator(final String desc, String ad,String symbol) {
		this.desc = desc;
		this.ad = ad;
		this.symbol = symbol;
	}

	public String getDesc() {
		return desc;
	}
	public String getAd() {
		return ad;
	}
	public String getSymbol() {
		return symbol;
	}

	public static String toStringAllOperator() {
		return Arrays.toString(SearchOperator.values());
	}



}