package cn.tangjiabao.halodb.utils.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.tangjiabao.halodb.utils.exception.ExceptionUtils;

/**
 * 日期组件
 * @author von_change@163.com
 * @date 2015-6-13 下午7:44:10
 */
public class DateUtils extends cn.tangjiabao.third.utils.time.DateUtils {
	private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static Logger logger = LoggerFactory.getLogger(DateUtils.class);
	private DateUtils() {
	}

	public static TimeZone getGMTTimeZone() {
		return GMT;
	}

    public  static  String dateString(Date date){
    	return  format("yyyyMMdd", date); 
     }

    public  static  String dateString(){
     	return  dateString(new Date()); 
      }
	private static TimeZone getDefaultTimeZone() {
		return  null;
	}
	public static Date parse(String dateText) {
		try {
			return DateUtils.parseE(dateText);
		} catch (ParseException e) {
			logger.error(ExceptionUtils.getStackTrace(e));
		}
		return null;
	}
	public static Date parseE(String dateText) throws ParseException {
		SimpleDateFormat sdf = new SimpleDateFormat();
		TimeZone timeZone = getDefaultTimeZone();
		if (timeZone != null) {
			sdf.setTimeZone(timeZone);
		}
		return sdf.parse(dateText);
	}
    
	public static Date parse(String format, String dateText) throws ParseException {
		SimpleDateFormat sdf = new SimpleDateFormat(format);
		TimeZone timeZone = getDefaultTimeZone();
		if (timeZone != null) {
			sdf.setTimeZone(timeZone);
		}
		return sdf.parse(dateText);
	}

	public static String format(Date date) {
		SimpleDateFormat sdf = new SimpleDateFormat();
		TimeZone timeZone = getDefaultTimeZone();
		if (timeZone != null) {
			sdf.setTimeZone(timeZone);
		}
		return sdf.format(date);
	}

	public static String format(String format, Date date) {
		SimpleDateFormat sdf = new SimpleDateFormat(format);
		TimeZone timeZone = getDefaultTimeZone();
		if (timeZone != null) {
			sdf.setTimeZone(timeZone);
		}
		return sdf.format(date);
	}
	 public static void main(String[] args) {
		  System.out.println(DateUtils.parse("2012-12-11 12:11:11"));
	}
}
