package cn.tangjiabao.halodb.utils.string;

import java.text.MessageFormat;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import cn.tangjiabao.halodb.utils.convert.ConvertUtils;

/**
 * 字符串组件
 * 
 * @author von_change@163.com
 * @date 2015-6-14 下午10:39:45
 */
public class StringUtils extends cn.tangjiabao.third.utils.string.StringUtils {
	/**
	 * 是否为英文
	 * 
	 * @param checkValue
	 * @return boolean
	 */
	public static boolean isEnglish(String checkValue) {
		String el = "^[A-Za-z]+$";
		Pattern p = Pattern.compile(el);
		Matcher m = p.matcher(checkValue);
		return m.matches();
	}

	/**
	 * 生成不带_的uuid
	 * 
	 * @return 32位的uuid
	 */
	public static String uuid() {
		String uuid = UUID.randomUUID().toString();
		return StringUtils.remove(uuid, "-");

	}

	/**
	 * 简单模板实现
	 * 
	 * @param pattern
	 * @param arguments
	 * @return String
	 */
	public static String format(String pattern, Object... arguments) {
		MessageFormat temp = new MessageFormat(pattern);
		return temp.format(arguments);
	}

	public static String substringBefore(String str, String separator, int num) {
		String[] strs = StringUtils.split(str, separator);
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < num; i++) {
			sb.append(strs[i]).append(separator);
		}
		return StringUtils.substringBeforeLast(sb.toString(), separator);
	}

	public static String substringBefore(String[] strs, String separator, int num) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < num; i++) {
			sb.append(strs[i]).append(separator);
		}
		return StringUtils.substringBeforeLast(sb.toString(), separator);
	}

	/**
	 * 拼接字符串
	 * 
	 * @param strs
	 * @return String
	 */
	public static String addStr(String... strs) {
		StringBuffer sb = new StringBuffer();
		for (String string : strs) {
			sb.append(string);
		}
		return sb.toString();
	}

	/**
	 * 拼接字符串
	 * 
	 * @param objs
	 * @return String
	 */
	public static String addStr(Object... objs) {
		StringBuffer sb = new StringBuffer();
		for (Object obj : objs) {
			sb.append(ConvertUtils.toString(obj));
		}
		return sb.toString();
	}

	public static Boolean isNull(Object obj) {
		if (null == obj) {
			return true;
		}
		String str = String.valueOf(obj);
		if (StringUtils.isBlank(str)) {
			return true;
		}
		return false;
	}

	public static Boolean isNotNull(Object obj) {
		return !isNull(obj);
	}
}
