package cn.tangjiabao.halodb.dbutils.dao.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.handlers.ScalarHandler;

import cn.tangjiabao.halodb.core.AbstractHaloDao;
import cn.tangjiabao.halodb.core.map.HaloGetMap;
import cn.tangjiabao.halodb.core.utils.sql.SQLFormatter;
import cn.tangjiabao.halodb.dbutils.ProcRunner;
import cn.tangjiabao.halodb.dbutils.dao.IHaloDao;
import cn.tangjiabao.halodb.dbutils.dao.IHaloViewDao;
import cn.tangjiabao.halodb.dbutils.handlers.HaloBeanHandler;
import cn.tangjiabao.halodb.dbutils.handlers.HaloBeanListHandler;
import cn.tangjiabao.halodb.dbutils.handlers.HaloGetMapHandler;
import cn.tangjiabao.halodb.dbutils.handlers.HaloGetMapListHandler;
import cn.tangjiabao.halodb.utils.convert.ConvertUtils;
import cn.tangjiabao.halodb.utils.exception.ExceptionUtils;
import cn.tangjiabao.halodb.utils.logger.LogUtils;
import cn.tangjiabao.halodb.utils.string.StringUtils;

/**
 * 依赖DbUtils的操作的抽象类
 * @author von_change@163.com
 * @date 2015-6-14 下午10:15:38
 * @param <T>
 */
public abstract class AbstractDbUtilsHaloDao<T> extends AbstractHaloDao<T> implements IHaloDao<T>,IHaloViewDao<T>{
	@Resource
	private DataSource dataSource;
	private QueryRunner queryRunner;
	private ProcRunner procRunner;
	protected abstract Connection getConnection(DataSource dataSource);
	//private static final  Logger log  =  LoggerFactory.getLogger(AbstractHaloDao. class );
	protected void setDataSource(DataSource dataSource) {
		this.dataSource = dataSource;
	}
	private String generateMyCountSql(String sql) {
		return StringUtils.format("select count(1) from ({0}) temp ", sql);
	}
	protected long countMySqlResult(String sql, Object[] params) {
		String countSql = generateMyCountSql(sql);
		Object result = findBy(countSql, 1, params);
		return ConvertUtils.toLong(result);
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	private Object findBy(String sql, int columnIndex, Object[] params) {
		queryRunner = new QueryRunner(dataSource);
		Connection conn = getConnection(dataSource);
		//Connection conn = DataSourceUtils.getConnection(dataSource);
		Object object = null;
		try {
			object = queryRunner.query(conn,sql, new ScalarHandler(columnIndex), params);
		} catch (SQLException e) {
			logger.error("Error occured while attempting to query data", e);
		}
		return object;
	}

	protected List<T> queryList(String sql, Object[] params, Map<String, String> aliasMap) {
		logger.info(LogUtils.format("生成的sql为:", SQLFormatter.format(sql)));
		logger.info(LogUtils.attr("prams:", params));
		queryRunner = new QueryRunner(dataSource);
		Connection conn = getConnection(dataSource);
		List<T> list = new ArrayList<T>();
		try {
			list = queryRunner.query(conn, sql, new HaloBeanListHandler<T>(getEntityType(), aliasMap), params);
		} catch (SQLException e) {
			logger.error("Error occured while attempting to query data", e);
		}
		return list;
	}

	protected T queryOne(String sql, Object[] params, Map<String, String> aliasMap) {
		logger.info(LogUtils.format("生成的sql为:", SQLFormatter.format(sql)));
		logger.info(LogUtils.attr("prams:", params));
		queryRunner = new QueryRunner(dataSource);
		Connection conn =getConnection(dataSource);
		T bean = null;
		try {
			bean = queryRunner.query(conn, sql, new HaloBeanHandler<T>(getEntityType(), aliasMap), params);
		} catch (SQLException e) {
			logger.error("Error occured while attempting to query data", e);
		}
		return bean;
	}

	protected HaloGetMap queryUnique(String sql, Object[] params, Map<String, String> aliasMap) {
		logger.info(LogUtils.format("生成的sql为:", SQLFormatter.format(sql)));
		logger.info(LogUtils.attr("prams:", params));
		queryRunner = new QueryRunner(dataSource);
		Connection conn = getConnection(dataSource);
		HaloGetMap map = new HaloGetMap();
		try {
			map = queryRunner.query(conn,sql, new HaloGetMapHandler(), params);
		} catch (SQLException e) {
			logger.error("Error occured while attempting to query data", e);
		}
		return map;
	}
	



	protected Object insert(String sql, Object[] params) {
		logger.info(LogUtils.format("生成的sql为:", SQLFormatter.format(sql)));
		logger.info(LogUtils.attr("prams:", params));
		queryRunner = new QueryRunner(dataSource);
		Connection conn = getConnection(dataSource);
		Object object = null;
		try {		
			object = queryRunner.insert(conn, sql,new ScalarHandler<Object>(), params);
		} catch (SQLException e) {
			logger.error(ExceptionUtils.getStackTrace(e));
			logger.error("insert.插入记录错误：" + sql, e);
		}
		return object;
	}
	protected int delete(String sql, Object[] params) {
		return update(sql, params);
	}
	protected int update(String sql, Object[] params) {
		logger.info(LogUtils.format("生成的sql为:", SQLFormatter.format(sql)));
		logger.info(LogUtils.attr("prams:", params));
		queryRunner = new QueryRunner(dataSource);
		Connection conn = getConnection(dataSource);
		int affectedRows = 0;
		try {
				affectedRows = queryRunner.update(conn, sql, params);
		} catch (SQLException e) {
			logger.error(ExceptionUtils.getStackTrace(e));
			logger.error("insert.插入记录错误：" + sql, e);
		}
		return affectedRows;
	}
	protected HaloGetMap callProc(String sql, Object[] params) {
		logger.info(LogUtils.format("生成的sql为:", SQLFormatter.format(sql)));
		logger.info(LogUtils.attr("prams:", params));
		procRunner = new ProcRunner(dataSource);
		Connection conn = getConnection(dataSource);
		HaloGetMap map =null;
		try {
			map =procRunner.queryProc(conn, sql,  new HaloGetMapHandler(), params);
		} catch (SQLException e) {
			logger.error("Error occured while attempting to query data", e);
		}
		return map;
	}
	protected List<HaloGetMap> callProcList(String sql, Object[] params) {
		logger.info(LogUtils.format("生成的sql为:", SQLFormatter.format(sql)));
		logger.info(LogUtils.attr("prams:", params));
		procRunner = new ProcRunner(dataSource);
		Connection conn =getConnection(dataSource);
		List<HaloGetMap> mapList =null;
		try {
			//ResultSetHandler<T> rsh=new 
			mapList =procRunner.queryProc(conn, sql,  new HaloGetMapListHandler(), params);
		} catch (SQLException e) {
			logger.error("Error occured while attempting to query data", e);
		}
		return mapList;
	}


}
