package cn.tangjiabao.halodb.dbutils.dao;

import java.util.List;

import cn.tangjiabao.halodb.core.map.HaloGetMap;
import cn.tangjiabao.halodb.core.map.HaloMap;
import cn.tangjiabao.halodb.core.page.IPage;
import cn.tangjiabao.halodb.utils.map.MyHashMap;

public interface IHaloViewDao<T> {
	/**
	 * 查询列表
	 * 
	 * @param parameter
	 * @return List<T>
	 */
	public List<T> findList(HaloMap parameter);

	/**
	 * 查询第一条
	 * 
	 * @param parameter
	 * @return T
	 */
	public T findFirst(HaloMap parameter);

	/**
	 * 查询唯一一条
	 * 
	 * @param parameter
	 * @return T
	 */
	public T findOne(HaloMap parameter);

	/**
	 * 根据Id查找
	 * 
	 * @param id
	 * @return T
	 */
	public T findById(Object id);

	/**
	 * 查找唯一一条
	 * 
	 * @param parameter
	 * @return HaloGetMap
	 */
	public HaloGetMap findUnique(HaloMap parameter);

	/**
	 * 分页查找
	 * 
	 * @param page
	 * @param parameter
	 * @return IPage<T>
	 */
	public IPage<T> findPage(IPage<T> page, HaloMap parameter);

	/**
	 * 执行从xml获取的更新Sql
	 * 
	 * @param cudSql
	 * @param parameter
	 * @return 影响的条数
	 */
	public int cud(String cudSql, MyHashMap parameter);

	/**
	 * 执行存储过程
	 * 
	 * @param procedureName
	 * @param parameter
	 * @return HaloGetMap
	 */
	public HaloGetMap callProcedure(String procedureName, Object... parameter);

	/**
	 * 执行存储过程
	 * 
	 * @param procedureName
	 * @param parameter
	 * @return List<HaloGetMap>
	 */
	public List<HaloGetMap> callProcedureList(String procedureName, Object... parameter);
}
