package cn.tangjiabao.halodb.dbutils.dao;

import java.util.List;

import cn.tangjiabao.halodb.core.map.HaloGetMap;
import cn.tangjiabao.halodb.core.map.HaloMap;
import cn.tangjiabao.halodb.core.page.IPage;
import cn.tangjiabao.halodb.utils.map.MyHashMap;

/**
 * HaloDao接口
 * 
 * @author von_change@163.com
 * @date 2015-6-14 下午10:17:44
 * @param <T>
 */
public interface IHaloDao<T> {
	/**
	 * 保存
	 * 
	 * @param entity
	 * @return T
	 */
	public T save(T entity);

	/**
	 * 查询列表
	 * 
	 * @param parameter
	 * @return List<T>
	 */
	public List<T> findList(HaloMap parameter);

	/**
	 * 查询第一条数据
	 * 
	 * @param parameter
	 * @return T
	 */
	public T findFirst(HaloMap parameter);

	/**
	 * 查询唯一一条
	 * 
	 * @param parameter
	 * @return T
	 */
	public T findOne(HaloMap parameter);

	/**
	 * 根据Id查找
	 * 
	 * @param id
	 * @return T
	 */
	public T findById(Object id);

	/**
	 * 查询唯一一条
	 * 
	 * @param parameter
	 * @return HaloGetMap
	 */
	public HaloGetMap findUnique(HaloMap parameter);

	/**
	 * 分页查找
	 * 
	 * @param page
	 * @param parameter
	 * @return IPage<T>
	 */
	public IPage<T> findPage(IPage<T> page, HaloMap parameter);

	/**
	 * 删除
	 * 
	 * @param parameter
	 * @return 删除的条数
	 */
	public int delete(HaloMap parameter);

	/**
	 * 根据Id删除
	 * 
	 * @param id
	 * @return 0或1
	 */
	public int deleteById(Object id);

	/**
	 * 根据实体删除
	 * 
	 * @param entity
	 * @return 0或1
	 */
	public int delete(T entity);

	/**
	 * 更新
	 * 
	 * @param entity
	 * @param parameter
	 * @return 更新的条数
	 */
	public int update(T entity, HaloMap parameter);

	/**
	 * 更新
	 * 
	 * @param entity
	 * @param nullFields
	 *            更新为NULL值得字段
	 * @return 0或1
	 */
	public int update(T entity, String... nullFields);

	/**
	 * 更新
	 * 
	 * @param entity
	 * @return 0或1
	 */
	public int update(T entity);

	/**
	 * 执行从xml中获取更新的Sql
	 * 
	 * @param cudSql
	 * @param parameter
	 * @return 影响的列数
	 */
	public int cud(String cudSql, MyHashMap parameter);

	/**
	 * 执行存储过程
	 * 
	 * @param procedureName
	 * @param parameter
	 * @return HaloGetMap
	 */
	public HaloGetMap callProcedure(String procedureName, Object... parameter);

	/**
	 * 执行存储过程
	 * 
	 * @param procedureName
	 * @param parameter
	 * @return List<HaloGetMap>
	 */
	public List<HaloGetMap> callProcedureList(String procedureName, Object... parameter);
}
