package cn.tangjiabao.halodb.dbutils;

import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

import cn.tangjiabao.halodb.core.exception.CannotGetConnectionException;

/**
 *DbUtils扩展组件
 * @author von_change@163.com
 * @date 2015-6-14 下午10:27:24
 */
public class DbUtilsEx{
    private  static  Connection  preConnection(DataSource dataSource) throws SQLException{
        if (null==dataSource) {
            throw new SQLException(
                    "QueryRunner requires a DataSource to be "
                            + "invoked in this way, or a Connection should be passed in");
        }
    	return dataSource.getConnection();
    }
    public static Connection  getConnection(DataSource dataSource) throws CannotGetConnectionException{
    	Connection conn= null;
    	try {
    		conn=preConnection(dataSource);
		} catch (SQLException ex) {
			throw new CannotGetConnectionException("Could not get JDBC Connection", ex);
		}
		return conn;
    }
}
