package cn.tangjiabao.halodb.core.utils.xml;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import cn.tangjiabao.halodb.core.bean.Join;
import cn.tangjiabao.halodb.core.exception.MyRuntimeException;
import cn.tangjiabao.halodb.utils.Base;
import cn.tangjiabao.halodb.utils.exception.ExceptionUtils;
import cn.tangjiabao.halodb.utils.logger.LogUtils;
import cn.tangjiabao.halodb.utils.md5.MD5Util;
import cn.tangjiabao.halodb.utils.string.StringUtils;

/**
 * xml组件
 * @author von_change@163.com
 * @date 2015-6-14 下午6:30:58
 */
public class XmlUtils extends Base {
	private static String VIEW = "view";
	private static String SQL = "sql";
	private static String CUDSQL = "cudSql";
	private static String COLUMN = "column";
	private static String ID = "id";
	private static String JOIN="join";
	private static String ALIAS="alias";
	private static String FIELD="field";
	private static String CLASS="class";
	private Document document;
	private static Map<String, Document> fileTimeMap = new HashMap<String, Document>();

	public XmlUtils(File xml) {
		long lastModifiedTime = xml.lastModified();
		logger.info(LogUtils.format("xml位置",  xml.getPath()));
		logger.info(LogUtils.format("修改时间::",  lastModifiedTime));
		if (lastModifiedTime != 0) {
			String md5File = MD5Util.getMD5(xml.getPath()+lastModifiedTime);
			if (null != fileTimeMap.get(md5File)) {
				document = fileTimeMap.get(md5File);
			} else {
				document = load(xml);
				fileTimeMap.put(md5File, document);
			}
		} else {
			throw new MyRuntimeException(xml.getPath()+"文件找不到!");
		}
	}

	public Document load(File xml) {
		SAXReader reader = new SAXReader();
		Document document = null;
		try {
			document = reader.read(xml);
		} catch (DocumentException e) {
			logger.error(ExceptionUtils.getStackTrace(e));
		}
		return document;
	}
	/**
	 * 根据Id获得Label的值
	 * @param label
	 * @param id
	 * @return Label的值
	 */
	@SuppressWarnings("unchecked")
	public String getLabel(String label, String id) {
		Element rootElement = document.getRootElement();
		Element hqlsElement = rootElement.element(label + "s");
		if (null == hqlsElement) {
			return null;
		}
		List<Element> hqlElements = hqlsElement.elements(label);
		for (Element element : hqlElements) {
			Attribute attribute = element.attribute(ID);
			if (null == attribute) {
				if (null == id) {
					return element.getTextTrim();
				}
			}
			if (null != attribute) {
				if (attribute.getValue().equals(id)) {
					return element.getTextTrim();
				}
			}
		}
		return null;
	}
	/**
	 * 获得更新的SQL
	 * @param id
	 * @return 更新的SQL
	 */
	public String getUpdateSql(String id) {
		return getLabel(CUDSQL, id);
	}
	/**
	 * 获得haloView的SQL
	 * @return haloView里的SQL
	 */
	public String getView() {
		Element rootElement = document.getRootElement();
		Element hqlsElement = rootElement.element(VIEW );
		if (null == hqlsElement) {
			return null;
		}
	  return hqlsElement.getTextTrim();
	}
	/**
	 * 获得Sql片段
	 * @param id
	 * @return Sql片段
	 */
	public String getSql(String id) {
		return getLabel(SQL, id);
	}
	/**
	 * 获得字段
	 * @param id
	 * @return 字段SQL
	 */
	public String getColumn(String id) {
		return getLabel(COLUMN, id);
	}
	/**
	 *根据alias获得连接信息
	 * @param alias
	 * @return 连接信息
	 */
	@SuppressWarnings("unchecked")
	public Join getJoin(String alias) {
		Join join = new Join();
		Element rootElement = document.getRootElement();
		Element hqlsElement = rootElement.element(JOIN + "s");
		if (null == hqlsElement) {
			return null;
		}
		List<Element> hqlElements = hqlsElement.elements(JOIN);
		for (Element element : hqlElements) {
			Attribute attribute = element.attribute(ALIAS);
			if (null == attribute) {
				 throw new RuntimeException("必须有别名！");
			}
			if (null != attribute) {
				if (attribute.getValue().equals(alias)) {
					join.setAlias(alias);
					String fieldName=element.attributeValue(FIELD).trim();
					join.setField(fieldName);
					String classPath=element.attributeValue(CLASS).trim();
					join.setClasspath(classPath);
					String[] fields=fieldName.split("\\.");
					join.setLevel(fields.length);
					if(fields.length>1){
						join.setDependField(StringUtils.substringBeforeLast(fieldName, "."));
					}
					join.setJoinSql(element.getTextTrim());
					return join;
				}
			}
		}
		return null;
	}
	/**
	 * 根据field找到alias
	 * @param filed
	 * @return alias
	 */
	@SuppressWarnings("unchecked")
	public String getDependAliasByField(String filed) {
		Element rootElement = document.getRootElement();
		Element hqlsElement = rootElement.element(JOIN + "s");
		if (null == hqlsElement) {
			return null;
		}
		List<Element> hqlElements = hqlsElement.elements(JOIN);
		for (Element element : hqlElements) {
			Attribute attribute = element.attribute(FIELD);
			if (null == attribute) {
				 throw new RuntimeException("必须有字段对应！");
			}
			if (null != attribute) {
				if (attribute.getValue().equals(filed)) {
					return element.attributeValue(ALIAS).trim();
				}
			}
		}
		return null;
	}
	/**
	 * 获得可以转换的时间格式
	 * @return 可以转换的时间格式
	 */
	@SuppressWarnings("unchecked")
	public String[] getPattern() {
		List<String> patterns = new ArrayList<String>();
		Element rootElement = document.getRootElement();
		Element hqlsElement = rootElement.element("pattern");
		if (null == hqlsElement) {
			return patterns.toArray(new String[0]);
		}
		List<Element> hqlElements = hqlsElement.elements("format");
		for (Element element : hqlElements) {
			if (StringUtils.isNotBlank(element.getTextTrim())) {
				patterns.add(element.getTextTrim());
			}
		}
		return patterns.toArray(new String[patterns.size()]);
	}

}
