package cn.tangjiabao.halodb.core.utils.orm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.log4j.Logger;

import cn.tangjiabao.halodb.core.bean.SelectColumn;
import cn.tangjiabao.halodb.core.constant.HaloConstant;
import cn.tangjiabao.halodb.core.exception.NotAllowDBColumnException;
import cn.tangjiabao.halodb.utils.logger.LogUtils;
import cn.tangjiabao.halodb.utils.map.HashMap;
import cn.tangjiabao.halodb.utils.string.StringUtils;

/**
 *Orm组件
 * @author von_change@163.com
 * @date 2015-6-14 下午1:02:52
 */
public class OrmUtil {
	private static Logger logger = Logger.getLogger(OrmUtil.class);
	/**
	 * _转大写
	 * @param value
	 */
	public static String toUp(String value) {
		StringBuffer sb = new StringBuffer();
		boolean flag = false;
		for (int i = 0; i < value.length(); i++) {
			char cur = value.charAt(i);
			if (cur == '_') {
				flag = true;

			} else {
				if (flag) {
					sb.append(Character.toUpperCase(cur));
					flag = false;
				} else {
					sb.append(cur);
				}
			}
		}
		return sb.toString();
	}

	/**
	 * 数据库表名转实体名
	 * @param tableName
	 * @return 实体名
	 */
	public static String toEntity(String tableName) {
		StringBuffer sb = new StringBuffer();
		boolean flag = false;
		for (int i = 0; i < tableName.length(); i++) {
			char cur = tableName.charAt(i);
			if (cur == '_') {
				flag = true;

			} else {
				if (flag) {
					sb.append(Character.toUpperCase(cur));
					flag = false;
				} else {
					sb.append(Character.toLowerCase(cur));
				}

			}
		}
		return StringUtils.capitalize(sb.toString());
	}

	/**
	 * 数据库字段名转实体类字段名
	 * @param colName
	 * @return 实体类字段名
	 */
	public static String toFiled(String colName) {
		StringBuffer sb = new StringBuffer();
		boolean flag = false;
		for (int i = 0; i < colName.length(); i++) {
			char cur = colName.charAt(i);
			if (cur == '_') {
				flag = true;

			} else {
				if (flag) {
					sb.append(Character.toUpperCase(cur));
					flag = false;
				} else {
					sb.append(Character.toLowerCase(cur));
				}
			}
		}
		return StringUtils.replaceEach(sb.toString(), HaloConstant.CharToNum.NUM, HaloConstant.CharToNum.CHAR);
	}

	/**
	 * Hql转成sql
	 * @param myHql
	 * @return sql
	 */
	public static String toSql(String myHql) {
		StringBuffer sb = new StringBuffer();
		boolean flag = false;
		boolean isLetter = false;
		for (int i = 0; i < myHql.length(); i++) {
			char cur = myHql.charAt(i);
			if (cur == '_') {
				throw new NotAllowDBColumnException("不允许使用数据库字段!");
			}
			if (cur == ':') {
				flag = true;
			}
			if (cur != ':' && !Character.isLetter(cur)) {
				flag = false;
			}
			if (flag) {
				sb.append(cur);
				continue;
			}
			if (Character.isUpperCase(cur) && isLetter) {
				sb.append("_");
				sb.append(Character.toLowerCase(cur));
			} else {
				sb.append(Character.toLowerCase(cur));
			}
			if (!Character.isLetter(cur)) {
				isLetter = false;
			} else {
				isLetter = true;
			}
		}
		return StringUtils.replaceEach(sb.toString(), HaloConstant.CharToNum.CHAR, HaloConstant.CharToNum.NUM);
	}

	public static String StrNums(String str, String split, int num) {
		if(num==0){
			return "";
		}
		StringBuffer fullStr = new StringBuffer();
		for (int i = 0; i < num; i++) {
			fullStr.append(str).append(split);
		}
		return fullStr.substring(0, fullStr.length()-split.length());
	}

	public static String StrList(List<String> strs, String split) {
		if(null==strs||strs.size()==0){
			return "";
		}
		StringBuffer fullStr = new StringBuffer();
		for (String string : strs) {
			fullStr.append(string).append(split);
		}
		return fullStr.substring(0, fullStr.length()-split.length());
	}

	/**
	 *  从sql语句中获得alias
	 * @param sqlFragment
	 * @return Map
	 */
	public static Map<String, Boolean> getAliasFromSql(String sqlFragment) {
		Map<String, Boolean> aliasMap = new HashMap<String, Boolean>();
		Matcher m = Pattern.compile("([\\w]*\\.[\\w]*)").matcher(sqlFragment);
		while (m.find()) {
			String group = m.group();
			System.out.println(group);
			if (!group.startsWith("t.")) {
				String aliasStr = StringUtils.substringBefore(group, ".");
				aliasMap.put(aliasStr, false);
			}
		}
		return aliasMap;
	}

	/**
	 * 分析查询字段语句
	 * @param columnStr
	 * @return SelectColumn
	 */
	public static SelectColumn analyzeSelectColumn(String columnStr) {
		SelectColumn selectColumn = new SelectColumn();
		selectColumn.setOrgColumnSql(columnStr);
		HashMap<String, Boolean> aliasMap = new HashMap<String, Boolean>();
		Matcher mas = Pattern.compile("(as[ ]*[\\w]*\\.[\\w]*)").matcher(columnStr);
		while (mas.find()) {
			String group = mas.group();
			String repalceStr = group.replace(".", HaloConstant.DIANINALIAS);
			if (!repalceStr.equals(group)) {
				columnStr = columnStr.replace(group, repalceStr);
			}
		}
		Matcher m = Pattern.compile("([\\@\\w]*\\.[\\w]*)").matcher(columnStr);
		List<String> patternListW = new ArrayList<String>();
		List<String> replaceStrListW = new ArrayList<String>();
		while (m.find()) {
			String group = m.group();
			StringBuffer repalceStr = new StringBuffer();
			if (!group.startsWith("t.")) {
				String aliasStr = StringUtils.substringBefore(group, ".");
				aliasMap.set(aliasStr, false);
				String alias = group.replace(".", HaloConstant.DIANINALIAS);
				repalceStr.append(group).append(" as ").append(alias);
				if (group.startsWith("@")) {
					repalceStr = new StringBuffer();
					repalceStr.append(group.substring(1));
				}
				patternListW.add(group);
				replaceStrListW.add(repalceStr.toString());
			}
		}
		columnStr=StringUtils.replaceEach(columnStr, patternListW.toArray(new String[patternListW.size()]), replaceStrListW.toArray(new String[replaceStrListW.size()]));
		selectColumn.setCookedColumnSql(columnStr);
		selectColumn.setAliasMap(aliasMap);
		logger.info(LogUtils.format("字段sql", columnStr));
		return selectColumn;
	}

}
