package cn.tangjiabao.halodb.core.base;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import cn.tangjiabao.halodb.core.annotation.HaloExclusion;
import cn.tangjiabao.halodb.core.annotation.HaloId;
import cn.tangjiabao.halodb.core.bean.ColumnCondition;
import cn.tangjiabao.halodb.core.bean.Entity;
import cn.tangjiabao.halodb.core.bean.EntityField;
import cn.tangjiabao.halodb.core.bean.Join;
import cn.tangjiabao.halodb.core.bean.SqlFragment;
import cn.tangjiabao.halodb.core.bean.TableSql;
import cn.tangjiabao.halodb.core.constant.HaloConstant;
import cn.tangjiabao.halodb.core.enums.HaloTime;
import cn.tangjiabao.halodb.core.enums.HaloType;
import cn.tangjiabao.halodb.core.enums.SearchOperator;
import cn.tangjiabao.halodb.core.exception.MyRuntimeException;
import cn.tangjiabao.halodb.core.utils.named.NamedParameterUtils;
import cn.tangjiabao.halodb.core.utils.named.ParsedSql;
import cn.tangjiabao.halodb.core.utils.orm.OrmUtil;
import cn.tangjiabao.halodb.core.utils.xml.XmlUtils;
import cn.tangjiabao.halodb.utils.Base;
import cn.tangjiabao.halodb.utils.clazz.ClassUtils;
import cn.tangjiabao.halodb.utils.convert.ConvertUtils;
import cn.tangjiabao.halodb.utils.exception.ExceptionUtils;
import cn.tangjiabao.halodb.utils.file.FileUtils;
import cn.tangjiabao.halodb.utils.logger.LogUtils;
import cn.tangjiabao.halodb.utils.map.HashMap;
import cn.tangjiabao.halodb.utils.string.StringUtils;
import cn.tangjiabao.halodb.utils.time.DateUtils;

/**
 * 需要的基础方法
 * 
 * @author von_change@163.com
 * @date 2015-6-13 下午6:39:58
 * @param <T>
 */
public abstract class HaloCore<T> extends Base {
	public static final Map<String, Entity> entityMap = new HashMap<String, Entity>();
	

	public abstract Class<T> getEntityType();

	protected Class<T> entityType = getEntityType();

	protected String getEntityName() {
		return this.entityType.getSimpleName();
	}

	private static long configTime = 0;
	private static String[] pattern;

	/**
	 * 获取可以转换的时间格式
	 * 
	 * @return 时间格式String数组
	 */
	private String[] getPattern() {
		File xmlPath = FileUtils.getClassPath("", "halo-config.xml");
		long lastModified = xmlPath.lastModified();
		if (lastModified == 0) {
			throw new MyRuntimeException("请配置支持的时间格式");
		} else {
			if (configTime == lastModified) {
				return pattern;
			} else {
				configTime = xmlPath.lastModified();
				XmlUtils xmlUtils = new XmlUtils(xmlPath);
				pattern = xmlUtils.getPattern();
				return pattern;
			}
		}
	}

	/**
	 * 实例化该实体
	 * 
	 * @return 实体实例
	 */
	protected T getInstanceEntity() {
		T entity = null;
		try {
			entity = this.entityType.newInstance();
		} catch (InstantiationException e) {
			logger.error(LogUtils.format(ExceptionUtils.getStackTrace(e)));
		} catch (IllegalAccessException e) {
			logger.error(LogUtils.format(ExceptionUtils.getStackTrace(e)));
		}
		return entity;
	}

	/**
	 * 初始化实体信息
	 * 
	 * @param clazz
	 *            实体类
	 */
	protected void initEntityInfo(Class<?> clazz) {
		long a = System.currentTimeMillis();
		String entityName = clazz.getSimpleName();
		File file = FileUtils.getClassPath(clazz);
		logger.debug(file.getAbsolutePath());
		long entityLastModified = file.lastModified();
		logger.debug(LogUtils.format("类文件时间", entityLastModified));
		if (0 == entityLastModified) {
			throw MyRuntimeException.Instance(entityName, "文件未找到");
		}
		if (null != entityMap.get(entityName)) {
			Entity entityInfo = entityMap.get(entityName);
			if (entityInfo.getLastModified() != entityLastModified) {
				initEntity(clazz, entityName, entityLastModified);
			}
			long c = System.currentTimeMillis();
			logger.debug("BBB:" + (c - a));
			return;
		}
		initEntity(clazz, entityName, entityLastModified);
		long b = System.currentTimeMillis();
		logger.debug("AAA:" + (b - a));
	}

	private void initEntity(Class<?> clazz, String entityName, long entityLastModified) {
		logger.info(LogUtils.format("初始化", entityName));
		Entity entity = new Entity();
		entity.setLastModified(entityLastModified);
		entity.setEntityName(entityName);
		entity.setTableName(OrmUtil.toSql(entityName));
		Field[] fileds = clazz.getDeclaredFields();// 只有本类
		Map<String, EntityField> entityFieldMap = new HashMap<String, EntityField>();
		for (Field field : fileds) {
			EntityField entityField = new EntityField();
			String fieldName = field.getName();
			entityField.setFieldName(fieldName);
			String columnName = OrmUtil.toSql(fieldName);
			entityField.setColumnName(columnName);
			Class<?> type = field.getType();
			entityField.setTypeName(type.getSimpleName());
			Boolean isBaseType = ClassUtils.isBaseType(type);
			entityField.setIsBaseType(isBaseType);
			if (isBaseType) {
				entityField.setIsColumn(true);
			}
			Annotation[] annotations = field.getAnnotations();
			for (Annotation annotation : annotations) {
				if (annotation instanceof HaloId) {
					entityField.setIsId(true);
					entity.setIdFieldName(fieldName);
					entity.setIdColumnName(columnName);
					entity.setIdType(type.getSimpleName());
					boolean auto = ((HaloId) annotation).auto();
					if (auto) {
						if (type.getSimpleName().equals("String")) {
							entity.setIdModel(HaloConstant.Entity.UUID);
						} else {
							entity.setIdModel(HaloConstant.Entity.INCID);
						}
					}
				}
				if (annotation instanceof HaloExclusion) {
					entityField.setIsColumn(false);
				}
			}
			entityFieldMap.put(fieldName, entityField);
		}
		entity.setFieldMap(entityFieldMap);
		entityMap.put(entityName, entity);
	}

	/**
	 * 获取字段的类型
	 * 
	 * @param filedName
	 *            字段名
	 * @param xmlUtils
	 * @return 类型名
	 */
	protected String getFieldType(String filedName, XmlUtils xmlUtils) {
		String result = null;
		String entityName = getEntityName();
		Entity entityInfo = entityMap.get(entityName);
		if (filedName.startsWith("t.")) {
			filedName = filedName.substring(2);
			result = entityInfo.getFieldMap().get(filedName).getTypeName();
		} else {
			String alias = StringUtils.substringBefore(filedName, ".");
			String field = StringUtils.substringAfter(filedName, ".");
			Join join = xmlUtils.getJoin(alias);
			String classPath = join.getClasspath();
			Class<?> clazz = ClassUtils.forName(classPath);
			initEntityInfo(clazz);
			String joinEntityName = clazz.getSimpleName();
			Entity joinEntityInfo = entityMap.get(joinEntityName);
			result = joinEntityInfo.getFieldMap().get(field).getTypeName();
		}
		return result;
	}

	/**
	 * 检查是否含空格：值不允许空格
	 * 
	 * @param value
	 * @return
	 */
	protected String CheckSpace(String value) {
		if (value.indexOf(HaloConstant.SPACE) != -1) {
			throw new MyRuntimeException("不允许包含空格!");
		}
		if (value.startsWith("_")) {
			value = value.substring(1, value.length());
		}
		return value;
	}

	private String replaceNum(String value) {
		return StringUtils.replaceEach(value, HaloConstant.NumToSymbol.NUMS, HaloConstant.NumToSymbol.NUMREPLACE);
	}

	/**
	 * 处理key值
	 * 
	 * @param key
	 * @return 处理过的key
	 */
	protected String filterKey(String key) {
		return replaceNum(CheckSpace(key));
	}

	/**
	 * 转换成Date类型
	 * 
	 * @param value
	 * @return Date时间
	 */
	protected Date convertToDate(Object value) {
		if (value instanceof Date) {
			return (Date) value;
		}
		Date result = null;
		try {
			result = DateUtils.parseDate(String.valueOf(value), getPattern());
		} catch (ParseException e) {
			logger.error(ExceptionUtils.getStackTrace(e));
		}
		return result;
	}

	/**
	 * 值转换成字段对应的类型
	 * 
	 * @param value
	 * @param type
	 * @param valueType
	 * @return 转换过的值
	 */
	protected Object convertValue(Object value, String type, String valueType) {
		if (null == type) {
			return value;
		}
		logger.info(LogUtils.formatOL("类型", type + "对" + valueType));
		if (!valueType.equalsIgnoreCase(type)) {
			if (HaloType.String.getName().equalsIgnoreCase(type)) {
				value = ConvertUtils.toString(value);
				return value;
			}
			if (HaloType.Integer.getName().equalsIgnoreCase(type)) {
				value = ConvertUtils.toInteger(value);
				return value;
			}
			if (HaloType.Long.getName().equalsIgnoreCase(type)) {
				value = ConvertUtils.toLong(value);
				return value;
			}
			if (HaloType.Boolean.getName().equalsIgnoreCase(type)) {
				value = ConvertUtils.toBoolean(value);
				return value;
			}
			if (HaloType.Double.getName().equalsIgnoreCase(type)) {
				value = ConvertUtils.toDouble(value);
				return value;
			}
			if (HaloType.Float.getName().equalsIgnoreCase(type)) {
				value = ConvertUtils.toFloat(value);
				return value;
			}
			if (HaloType.Short.getName().equalsIgnoreCase(type)) {
				value = ConvertUtils.toShort(value);
				return value;
			}
			if (HaloType.Byte.getName().equalsIgnoreCase(type)) {
				value = ConvertUtils.toByte(value);
				return value;
			}
			if (HaloType.TimeStamp.getName().equalsIgnoreCase(type) || HaloType.DatetTme.getName().equalsIgnoreCase(type) || HaloType.Date.getName().equalsIgnoreCase(type)) {
				if (value instanceof String) {
					value = convertToDate(value);
				}
				return value;
			}
			if (HaloType.big_decimal.getName().equalsIgnoreCase(type) || HaloType.BigDecimal.getName().equalsIgnoreCase(type)) {
				if (!(value instanceof BigDecimal)) {
					value = ConvertUtils.toBigDecimal(value);
				}
				return value;
			}
		}
		return value;
	}

	/**
	 * 获取该实体的xmlUtils对象
	 * 
	 * @return xmlUtils对象
	 */
	protected XmlUtils getXml() {
		return new XmlUtils(getXmlFile(this.entityType));
	}

	/**
	 * 根据classpath获取xmlUtils对象
	 * 
	 * @param classpath
	 * @return xmlUtils对象
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	protected XmlUtils getXmlByClassPath(String classpath) {
		Class clazz = ClassUtils.forName(classpath);
		return getXml(clazz);
	}

	private XmlUtils getXml(Class<T> entityType) {
		return new XmlUtils(getXmlFile(entityType));
	}

	private File getXmlFile(Class<T> entityType) {
		String entityName = entityType.getSimpleName();
		File xmlPathFile = FileUtils.getClassPath(entityType, entityName + ".xml");
		return xmlPathFile;
	}

	/**
	 * 分析key值
	 * 
	 * @param columnCondition
	 * @param key
	 * @param value
	 * @return 字段条件实体
	 */
	protected ColumnCondition analyzeKey(ColumnCondition columnCondition, String key, Object value) {
		// addColumn
		columnCondition.setValue(value);
		if (key.startsWith("(")) {
			columnCondition.setLeftBracket("(");
		}
		if (key.startsWith("|")) {
			columnCondition.setAndOr("or");
		}
		if (key.endsWith(")")) {
			columnCondition.setRightBracket(")");
		}
		key = key.replaceAll("\\(|\\||\\)", "");
		String[] keyWithType = key.split(HaloConstant.TAPESPT);
		if (keyWithType.length == 2) {
			columnCondition.setType(keyWithType[1]);
			key = keyWithType[0];
		}
		String[] keys = key.split(HaloConstant.MYSPACE);
		boolean queryFlag = judgeIfNeedQuery(keys, value);// 判断是否需要进行查询
		if (queryFlag) {
			columnCondition.setIfQuery(true);
			columnCondition = analyzeKeys(columnCondition, keys, value);
			// 转换类型
			if (columnCondition.getParameterNum() > 0) {
				List<Object> cookedValue = cookedValue(columnCondition);
				columnCondition.setCookedValue(cookedValue);
			}
			if (!columnCondition.getXmlSqlFlag()) {
				StringBuffer sqlFragment = new StringBuffer();
				sqlFragment.append(columnCondition.getLeftBracket()).append(HaloConstant.SPACE).append(columnCondition.getTableAs()).append(columnCondition.getColumnName()).append(HaloConstant.SPACE).append(columnCondition.getCondition()).append(HaloConstant.SPACE).append(columnCondition.getDirectValue()).append(HaloConstant.SPACE).append(columnCondition.getRightBracket()).append(HaloConstant.SPACE);
				columnCondition.setSqlFragment(sqlFragment.toString());
			}
		}
		return columnCondition;
	}

	/**
	 * 判断是否需要进行查询
	 * 
	 * @param keys
	 * @param value
	 * @return 是否需要进行查询
	 */
	private boolean judgeIfNeedQuery(String[] keys, Object value) {
		if (keys.length == 3 && keys[2].equals(HaloConstant.RX)) {
			return true;
		}
		if (keys.length == 2 && keys[1].equals(SearchOperator.sql.getAd())) {
			return true;
		}
		if (null != value && !StringUtils.isBlank(value.toString())) {
			if (keys.length > 1) {
				return true;
			}
		}
		if (keys.length == 3 && keys[2].equals(HaloConstant.CK)) {
			throw new RuntimeException("传入值为空!请自行处理!");
		}
		return false;
	}

	/**
	 * 分析sql片段
	 * 
	 * @param sqlFragment
	 * @param value
	 * @return SqlFragment
	 */
	@SuppressWarnings("unchecked")
	private SqlFragment analyzeSqlFragment(String sqlFragment, Object value) {
		SqlFragment sqlFragmentBean = new SqlFragment();
		Object[] attrValue = null;
		if (value.getClass().isArray()) {
			attrValue = (Object[]) value;
		} else {
			attrValue = new Object[] { value };
		}
		List<Character> resultSql = new ArrayList<Character>();
		List<Object> params = new ArrayList<Object>();
		char[] sqlchars = sqlFragment.toCharArray();
		int paramCount = 0;
		int i = 0;
		while (i < sqlchars.length) {
			char statement = sqlchars[i];
			if (statement == '?') {
				Object paramValue = attrValue[paramCount];
				if (null != paramValue) {
					boolean flag = false;
					List<Object> resultList = new ArrayList<Object>();
					resultList.add(paramValue);
					Class<?> retType = paramValue.getClass();
					if (Collection.class.isAssignableFrom(retType)) {
						resultList = (List<Object>) paramValue;
						flag = true;
					} else if (retType.isArray()) {
						Object[] arrValue = (Object[]) paramValue;
						resultList = Arrays.asList(arrValue);
						flag = true;
					}
					if (flag && resultList.size() > 0) {
						String statementStr = OrmUtil.StrNums("?", ",", resultList.size());
						char[] chars = statementStr.toCharArray();
						for (char c : chars) {
							resultSql.add(c);
						}
						params.addAll(resultList);
					} else {
						resultSql.add(statement);
						params.add(resultList.get(0));
					}
				} else {
					resultSql.add(statement);
					params.add(paramValue);
				}
				paramCount++;
			} else {
				resultSql.add(statement);
			}
			i++;
		}
		StringBuffer sb = new StringBuffer();
		for (Character character : resultSql) {
			sb.append(character);
		}
		sqlFragmentBean.setSql(sb.toString());
		sqlFragmentBean.setParams(params);
		return sqlFragmentBean;
	}

	private ColumnCondition analyzeKeys(ColumnCondition columnCondition, String[] keys, Object value) {
		String fieldName = keys[0];
		String[] alisaFields = fieldName.split("\\.");
		if (alisaFields.length > 1) {
			fieldName = alisaFields[1];
			columnCondition.setTableAs(alisaFields[0] + ".");
		}
		String columnName = OrmUtil.toSql(fieldName);
		String condition = keys[1];
		columnCondition.setFieldName(fieldName);
		// 获得类型
		String type = columnCondition.getType();
		if (null == type) {
			try {
				type = getFieldType(columnCondition.getTableAs() + columnCondition.getFieldName(), columnCondition.getXmlUtils());
			} catch (Exception e) {
				logger.warn("could not resolve property(无法得到字段类型)");
				type = null;
			}
			columnCondition.setType(type);
		}
		columnCondition.setColumnName(columnName);
		if (null != value) {
			Class<?> retType = value.getClass();
			if (Collection.class.isAssignableFrom(retType)) {
				Collection<?> colValue = (Collection<?>) value;
				columnCondition.setValue(colValue.toArray());
				columnCondition.setParameterNum(colValue.size());
			} else if (retType.isArray()) {
				Object[] arrValue = (Object[]) value;
				columnCondition.setParameterNum(arrValue.length);
			}
		}
		if (SearchOperator.sql.getAd().equals(condition)) {
			columnCondition.setXmlSqlFlag(true);
			XmlUtils xmlUtils = columnCondition.getXmlUtils();
			String sql = xmlUtils.getSql(columnCondition.getFieldName());
			if (null == value) {
				columnCondition.setParameterNum(0);
				columnCondition.setSqlFragment(sql);
			} else {
				SqlFragment sqlFragment = analyzeSqlFragment(sql, value);
				columnCondition.setSqlFragment(sqlFragment.getSql());
				columnCondition.setParameterNum(sqlFragment.getParams().size());
				columnCondition.setValue(sqlFragment.getParams().toArray());
				// 处理sql和 value
			}
			return columnCondition;
		}
		// 有几个参数就几个
		if (null == value || HaloConstant.NULLStr.equalsIgnoreCase(String.valueOf(value).trim())) {
			if (SearchOperator.eq.getAd().equals(condition)) {
				condition = SearchOperator.isNull.getAd();
				columnCondition.setCondition(SearchOperator.isNull.getSymbol());
				columnCondition.setDirectValue("");
				columnCondition.setParameterNum(0);
			}
			if (SearchOperator.neq.getAd().equals(condition)) {
				condition = SearchOperator.isNotNull.getAd();
				columnCondition.setCondition(SearchOperator.isNotNull.getSymbol());
				columnCondition.setDirectValue("");
				columnCondition.setParameterNum(0);
			}
			return columnCondition;
		}

		if (SearchOperator.eq.getAd().equals(condition)) {
			columnCondition.setCondition(SearchOperator.eq.getSymbol());
			return columnCondition;
		}
		if (SearchOperator.neq.getAd().equals(condition)) {
			columnCondition.setCondition(SearchOperator.neq.getSymbol());
			return columnCondition;
		}
		if (SearchOperator.gt.getAd().equals(condition)) {
			columnCondition.setCondition(SearchOperator.gt.getSymbol());
			return columnCondition;
		}
		if (condition.indexOf(SearchOperator.ge.getAd()) != -1) {
			condition = condition.replaceFirst(SearchOperator.ge.getAd(), "");// 替换ge
			columnCondition.setCondition(SearchOperator.ge.getSymbol());
			if (!"".equals(condition)) {
				columnCondition = extDateCondition(condition, "", false, columnCondition);
			}
			return columnCondition;
		}
		if (SearchOperator.lt.getAd().equals(condition)) {
			columnCondition.setCondition(SearchOperator.lt.getSymbol());
			return columnCondition;
		}
		if (condition.indexOf(SearchOperator.le.getAd()) != -1) {
			condition = condition.replaceFirst(SearchOperator.le.getAd(), "");
			columnCondition.setCondition(SearchOperator.le.getSymbol());
			if (!"".equals(condition)) {
				columnCondition = extDateCondition(condition, "", true, columnCondition);
			}
			return columnCondition;
		}

		if (condition.indexOf(SearchOperator.like.getAd()) != -1) {
			columnCondition.setCondition(SearchOperator.like.getSymbol());
			condition = condition.replaceFirst(SearchOperator.like.getAd(), "");
			columnCondition = extLikeCondition(condition, value, columnCondition);
			if (columnCondition.getTempFlag()) {
				columnCondition = extDateCondition(condition, "%", false, columnCondition);
			}
			return columnCondition;
		}
		if (condition.equals(SearchOperator.in.getAd())) {
			columnCondition.setCondition(SearchOperator.in.getSymbol());
			columnCondition.setDirectValue("(?)");
			return columnCondition;
		}
		if (condition.equals(SearchOperator.notIn.getAd())) {
			columnCondition.setCondition(SearchOperator.notIn.getSymbol());
			columnCondition.setDirectValue("(?)");
			return columnCondition;
		}
		if (condition.equals(SearchOperator.not.getAd())) {// 比如not 3 为!=3 or is
															// null
			columnCondition.setCondition(SearchOperator.not.getSymbol());
			columnCondition.setLeftBracket("(");
			columnCondition.setRightBracket(")");
			columnCondition.setDirectValue(StringUtils.format(" ? or {0} is null", columnName));
			return columnCondition;
		}
		if (condition.indexOf(SearchOperator.notLike.getAd()) != -1) {// 不常用
			columnCondition.setCondition(SearchOperator.notLike.getSymbol());
			condition = condition.replaceFirst(SearchOperator.notLike.getAd(), "");
			columnCondition = extLikeCondition(condition, value, columnCondition);
			if (columnCondition.getTempFlag()) {
				columnCondition = extDateCondition(condition, "%", false, columnCondition);
			}
			return columnCondition;
		}
		if (SearchOperator.isNull.getAd().equals(condition)) {
			columnCondition.setCondition(SearchOperator.isNull.getSymbol());
			columnCondition.setDirectValue("");
			columnCondition.setParameterNum(0);
			return columnCondition;
		}
		if (SearchOperator.isNotNull.getAd().equals(condition)) {
			columnCondition.setCondition(SearchOperator.isNotNull.getSymbol());
			columnCondition.setDirectValue("");
			columnCondition.setParameterNum(0);
			return columnCondition;
		}

		if (StringUtils.isEnglish(condition)) {// 比如 in
			columnCondition.setCondition(condition);
			return columnCondition;
		}
		throw new RuntimeException("本版本不再允许带符号条件传入!比如=,>换用eq,gt");
	}

	private List<Object> cookedValue(ColumnCondition columnCondition) {
		Object value = columnCondition.getValue();
		String type = columnCondition.getType();
		String valueType = null;
		Class<?> retType = value.getClass();
		Object[] values = new Object[] { value };
		if (retType.isArray()) {
			Object[] arrValue = (Object[]) value;
			values = arrValue;
			if (!columnCondition.getXmlSqlFlag()) {// 不是xml里的sql
				String prmStr = OrmUtil.StrNums("?", ",", columnCondition.getParameterNum());
				String directValueStr = columnCondition.getDirectValue();
				columnCondition.setDirectValue(directValueStr.replace("?", prmStr));
			}
		}
		if (values.length > 0) {
			valueType = values[0].getClass().getSimpleName();
		}
		List<Object> resultCol = new ArrayList<Object>();
		for (Object object : values) {
			resultCol.add(convertValue(object, type, valueType));
		}
		return resultCol;
	}

	private ColumnCondition extDateCondition(String extCondtion, String like, boolean addOne, ColumnCondition columnCondition) {
		Object value = columnCondition.getValue();
		if (HaloTime.day.getName().equals(extCondtion) || HaloTime.day.getAd().equals(extCondtion)) {
			Date date = convertToDate(value);
			if (addOne) {
				date = DateUtils.addDays(date, 1);
				columnCondition.setCondition("<");
			}
			columnCondition.setDirectValue("'" + DateUtils.format("yyyy-MM-dd", date) + like + "'");
			columnCondition.setParameterNum(0);
			return columnCondition;
		}
		if (HaloTime.month.getName().equals(extCondtion) || HaloTime.month.getName().equals(extCondtion)) {
			Date date = convertToDate(value);
			if (addOne) {
				date = DateUtils.addMonths(date, 1);
				columnCondition.setCondition("<");
			}
			columnCondition.setDirectValue("'" + DateUtils.format("yyyy-MM", date) + like + "'");
			columnCondition.setParameterNum(0);
			return columnCondition;
		}
		if (HaloTime.year.getName().equals(extCondtion) || HaloTime.year.getAd().equals(extCondtion)) {
			Date date = convertToDate(value);
			if (addOne) {
				date = DateUtils.addYears(date, 1);
				columnCondition.setCondition("<");
			}
			columnCondition.setDirectValue("'" + DateUtils.format("yyyy", date) + like + "'");
			columnCondition.setParameterNum(0);
			return columnCondition;
		}
		if (HaloTime.hour.getName().equals(extCondtion) || HaloTime.hour.getAd().equals(extCondtion)) {
			Date date = convertToDate(value);
			if (addOne) {
				date = DateUtils.addHours(date, 1);
				columnCondition.setCondition("<");
			}
			columnCondition.setDirectValue("'" + DateUtils.format("yyyy-MM-dd HH", date) + like + "'");
			columnCondition.setParameterNum(0);
			return columnCondition;
		}
		if (HaloTime.minute.getName().equals(extCondtion) || HaloTime.minute.getAd().equals(extCondtion)) {
			Date date = convertToDate(value);
			if (addOne) {
				date = DateUtils.addMinutes(date, 1);
				columnCondition.setCondition("<");
			}
			columnCondition.setDirectValue("'" + DateUtils.format("yyyy-MM-dd HH:mm", date) + like + "'");
			columnCondition.setParameterNum(0);
			return columnCondition;
		}

		if (HaloTime.second.getName().equals(extCondtion) || HaloTime.second.getAd().equals(extCondtion)) {
			Date date = convertToDate(value);
			if (addOne) {
				date = DateUtils.addSeconds(date, 1);
				columnCondition.setCondition("<");
			}
			columnCondition.setDirectValue("'" + DateUtils.format("yyyy-MM-dd HH:mm:ss", date) + like + "'");
			columnCondition.setParameterNum(0);
			return columnCondition;
		}
		return columnCondition;
	}

	private ColumnCondition extLikeCondition(String extCondtion, Object value, ColumnCondition columnCondition) {
		if ("".equals(extCondtion)) {// 默认左模糊查询
			String valueString = String.valueOf(value);
			if (valueString.indexOf("%") == -1) {
				value = valueString + "%";
			}
			columnCondition.setType(HaloType.String.name());
			columnCondition.setValue(value);
			columnCondition.setTempFlag(false);
			return columnCondition;
		}
		if ("%".equals(extCondtion)) {// 右模糊查询 5like
			String valueString = String.valueOf(value);
			if (valueString.indexOf("%") == -1) {
				value = "%" + valueString;
			}
			columnCondition.setType(HaloType.String.name());
			columnCondition.setValue(value);
			columnCondition.setTempFlag(false);
			return columnCondition;
		}
		if ("%%".equals(extCondtion)) {// 模糊查询 5like5
			String valueString = String.valueOf(value);
			if (valueString.indexOf("%") == -1) {
				value = "%" + valueString + "%";
			}
			columnCondition.setType(HaloType.String.name());
			columnCondition.setValue(value);
			columnCondition.setTempFlag(false);
			return columnCondition;
		}
		return columnCondition;
	}

	/**
	 * 获取字段sql中的alias
	 * 
	 * @param aliasMapInColumn
	 * @param xmlUtils
	 * @return Map
	 */
	protected Map<String, String> getColumnMappingAlias(Map<String, Boolean> aliasMapInColumn, XmlUtils xmlUtils) {
		Map<String, String> aliasMap = new HashMap<String, String>();
		for (Entry<String, Boolean> entry : aliasMapInColumn.entrySet()) {
			String alias = entry.getKey();
			Join join = xmlUtils.getJoin(alias);
			aliasMap.put(alias, join.getField());
		}
		return aliasMap;
	}

	/**
	 * 获得joinSql
	 * 
	 * @param joinSqlMap
	 * @return joinSql
	 */
	protected String getJoinSql(HashMap<Integer, String> joinSqlMap) {
		StringBuffer joinSqlBuffer = new StringBuffer();
		int level = joinSqlMap.size();
		if (level > 0) {
			for (int i = 1; i <= level; i++) {
				joinSqlBuffer.append(joinSqlMap.get(i));
			}
			return joinSqlBuffer.toString();
		}
		return "";
	}

	/**
	 * 分析aliasMap
	 * 
	 * @param aliasMap
	 * @param xmlUtils
	 * @param joinSqlMap
	 */
	protected void analyzeAliasMap(ConcurrentHashMap<String, Boolean> aliasMap, XmlUtils xmlUtils, HashMap<Integer, String> joinSqlMap) {
		if (aliasMap.isEmpty()) {
			return;
		}
		for (Entry<String, Boolean> entry : aliasMap.entrySet()) {
			String alias = entry.getKey();
			Boolean flag = entry.getValue();
			if (!flag) {
				Join join = xmlUtils.getJoin(alias);
				Integer level = join.getLevel();
				StringBuffer joinSqlBuffer = new StringBuffer();
				if (joinSqlMap.get(level) != null) {
					joinSqlBuffer.append(joinSqlMap.get(level));
				}
				joinSqlBuffer.append(HaloConstant.SPACE).append(join.getJoinSql()).append(HaloConstant.SPACE);
				joinSqlMap.set(level, joinSqlBuffer.toString());
				aliasMap.put(alias, true);
				if (join.getLevel() > 1) {
					String dependAlias = xmlUtils.getDependAliasByField(join.getDependField());
					if (null == aliasMap.get(dependAlias)) {
						aliasMap.put(dependAlias, false);
						analyzeAliasMap(aliasMap, xmlUtils, joinSqlMap);
					}
				}
			}

		}
	}

	/**
	 * 获得排序sql
	 * 
	 * @param value
	 * @param xmlUtils
	 * @return 排序sql
	 */
	protected String getOrderSql(String value, XmlUtils xmlUtils) {
		value = CheckSpace(value);
		if (value.endsWith("_sql")) {
			String id = value.substring(0, value.length() - 4);
			return xmlUtils.getSql(id);
		}
		if (value.endsWith("_desc")) {
			value = value.replace("_desc", " desc");
		}
		value = value.replace("8", ".");
		/*
		 * if(value.indexOf(".")==-1){ value="t."+value; }
		 */
		return OrmUtil.toSql(value);
	}

	/**
	 * 获取排序sql的List
	 * 
	 * @param orderSqlList
	 * @param value
	 * @param xmlUtils
	 * @return 排序sql的List
	 */
	protected List<String> getOrder(List<String> orderSqlList, Object value, XmlUtils xmlUtils) {
		if (value instanceof String) {
			String orderValue = (String) value;
			orderSqlList.add(getOrderSql(orderValue, xmlUtils));
		}
		if (value instanceof String[]) {
			for (String str : (String[]) value) {
				orderSqlList.add(getOrderSql(str, xmlUtils));
			}
		}
		return orderSqlList;
	}

	/**
	 * 获取表的sql
	 * 
	 * @param orgTableSql
	 * @param viewParams
	 * @return 表的sql
	 */
	protected TableSql getTableSql(String orgTableSql, Map<String, Object> viewParams) {
		TableSql tableSql = new TableSql();
		List<Object> params = new ArrayList<Object>();
		tableSql.setOrgTableSql(orgTableSql);
		List<String> haloViewList = getHaloView(orgTableSql);
		if (haloViewList.size() == 0) {
			tableSql.setTargetTableSql(orgTableSql);
			tableSql.setParams(params);
			return tableSql;
		}
		// 存在sql
		List<String> haloViewSqlList = new ArrayList<String>();
		for (String haloViewName : haloViewList) {
			String haloViewAliasName = StringUtils.substringAfterLast(haloViewName, " ");
			String haloViewSql = getHaloViewSql(haloViewAliasName);
			haloViewSqlList.add("(" + haloViewSql + ") " + haloViewAliasName);
		}
		String targetTableSql = StringUtils.replaceEach(orgTableSql, haloViewList.toArray(new String[haloViewList.size()]), haloViewSqlList.toArray(new String[haloViewSqlList.size()]));
		ParsedSql parsedSql = NamedParameterUtils.parserSqlStatement(targetTableSql);
		String tableSqlStr = NamedParameterUtils.substituteNamedParams(parsedSql, viewParams);
		tableSql.setTargetTableSql(tableSqlStr);
		params.addAll(NamedParameterUtils.buildValueArray(parsedSql, viewParams));
		tableSql.setParams(params);
		// 获得视图
		return tableSql;
	}

	/**
	 *替换HaloView
	 * @param cudSql
	 * @return
	 */
	protected String getCUDSql(String cudSql) {
		List<String> haloViewList = getHaloView(cudSql);
		if (haloViewList.size() == 0) {
			return cudSql;
		}
		List<String> haloViewSqlList = new ArrayList<String>();
		for (String haloViewName : haloViewList) {
			String haloViewAliasName = StringUtils.substringAfterLast(haloViewName, " ");
			String haloViewSql = getHaloViewSql(haloViewAliasName);
			haloViewSqlList.add("(" + haloViewSql + ") " + haloViewAliasName);
		}
		String targetTableSql = StringUtils.replaceEach(cudSql, haloViewList.toArray(new String[haloViewList.size()]), haloViewSqlList.toArray(new String[haloViewSqlList.size()]));
		return targetTableSql;
	}

	private String getHaloViewSql(String haloViewAliasName) {
		XmlUtils xmlUtils = getXml();
		if (haloViewAliasName.equals("t")) {
			return xmlUtils.getView();
		}
		Join join = xmlUtils.getJoin(haloViewAliasName);
		String classpath = join.getClasspath();
		XmlUtils viewXmlUtils = getXmlByClassPath(classpath);
		return viewXmlUtils.getView();
	}

	private static List<String> getHaloView(String orgTableSql) {
		List<String> haloViewList = new ArrayList<String>();
		Matcher m = Pattern.compile("Halo([\\w]*[ ]*[\\w]*)").matcher(orgTableSql);
		while (m.find()) {
			String group = m.group();
			haloViewList.add(group);
		}
		return haloViewList;
	}

}
