package cn.takujo.takujoframework.mybatis.sqlhelper.find;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * FindRule中要搜索的字段: column 对应数据库列名 alias 可以给搜索加别名
 * 
 * @author wzx
 *
 */
@Getter
@Setter
@ToString
public class FindField {

	private String column;
	private String alias;

	public FindField(String column, String alias) {
		this.column = column;
		this.alias = alias;
	}

	public FindField(String column) {
		this.column = column;
	}

	public String result() {
		if (alias != null && !alias.trim().isEmpty()) {
			return column + " " + alias;
		} else {
			return column;
		}
	}

}
