package cn.takujo.takujoframework.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

/**
 * get语句代码打印输出工具
 * 
 * @author wzx
 *
 */
public final class GetStatementCodePrintUtil {

	/**
	 * 打印输出
	 * 
	 * @param bean
	 *            Class类型
	 * @param objectName
	 *            对象名称
	 */
	public static void print(Class<?> bean, String objectName) {
		Field[] declaredFields = bean.getDeclaredFields();
		for (Field field : declaredFields) {
			String name = field.getName();
			String type = field.getType().getSimpleName();
			int modifiers = field.getModifiers();
			if (!isSerializableField(modifiers)) {
				System.out.println("\t" + type + " " + name + "=" + objectName + "." + "get"
						+ name.substring(0, 1).toUpperCase() + name.substring(1) + "();");
			}
		}
	}

	/**
	 * 判断是否为序列化字段
	 * 
	 * @param modifiers
	 * @return true：是 false：否
	 */
	private static boolean isSerializableField(int modifiers) {
		if (Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
			return true;
		} else {
			return false;
		}
	}

}
