/*
 * Decompiled with CFR 0.152.
 */
package cn.takujo.takujoframework.mappingfinder;

import cn.takujo.takujoframework.common.util.ClassUtil;
import cn.takujo.takujoframework.mappingfinder.Findable;
import cn.takujo.takujoframework.mappingfinder.Mapping;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MappingFinder {
    public static List<Mapping> enter(Class<?> enterClass, Class<? extends Annotation> requestMapping) {
        return MappingFinder.scan(enterClass.getPackage(), requestMapping);
    }

    public static List<Mapping> enter(Class<?> enterClass, Class<? extends Annotation> requestMapping, String outFile) {
        List<Mapping> scan = MappingFinder.scan(enterClass.getPackage(), requestMapping);
        File file = new File(outFile);
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        try {
            file.createNewFile();
            if (file.exists()) {
                FileOutputStream fo = new FileOutputStream(file);
                BufferedOutputStream bfo = new BufferedOutputStream(fo);
                for (Mapping mapping : scan) {
                    String mappingUrl = mapping.getMappingUrl();
                    String mappingMethod = mapping.getMappingMethod();
                    String requiredParam = mapping.getRequiredParam();
                    String returnValue = mapping.getReturnValue();
                    String description = mapping.getDescription();
                    String belongController = mapping.getBelongController();
                    String line = "| url: " + mappingUrl + " | method: " + mappingMethod + " | param: " + requiredParam + " | return: " + returnValue + " | controller: " + belongController + " | description: " + description + " | # ";
                    byte[] bytes = line.getBytes();
                    bfo.write(bytes);
                }
                bfo.flush();
                bfo.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return scan;
    }

    private static List<Mapping> scan(Package pkg, Class<? extends Annotation> valueAnnotation) {
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        List<Class<?>> list = ClassUtil.getClassesByPackage(pkg);
        if (!list.isEmpty()) {
            for (Class<?> c : list) {
                Method[] methods;
                String simpleName = c.getSimpleName();
                Findable claant = c.getAnnotation(Findable.class);
                if (claant != null) {
                    Method[] methods2;
                    String urlPrefix = "";
                    Annotation re = c.getAnnotation(valueAnnotation);
                    if (re != null) {
                        urlPrefix = MappingFinder.geturl(re);
                    }
                    String description = claant.value();
                    for (Method method : methods2 = c.getMethods()) {
                        Findable annotation = method.getAnnotation(Findable.class);
                        if (annotation != null) {
                            description = description + annotation.value();
                        }
                        MappingFinder.injectionMapping(mappings, method, valueAnnotation, simpleName, urlPrefix, description);
                    }
                    continue;
                }
                for (Method method : methods = c.getMethods()) {
                    Findable annotation = method.getAnnotation(Findable.class);
                    if (annotation == null) continue;
                    String urlPrefix = "";
                    Annotation re = c.getAnnotation(valueAnnotation);
                    if (re != null) {
                        urlPrefix = MappingFinder.geturl(re);
                    }
                    MappingFinder.injectionMapping(mappings, method, valueAnnotation, simpleName, urlPrefix, annotation.value());
                }
            }
        }
        return mappings;
    }

    private static void injectionMapping(List<Mapping> maps, Method method, Class<? extends Annotation> valueAnnotation, String simpleName, String urlPrefix, String description) {
        Annotation rm = method.getAnnotation(valueAnnotation);
        if (rm != null) {
            try {
                Mapping mapping = new Mapping();
                mapping.setBelongController(simpleName);
                mapping.setMappingMethod(method.getName());
                mapping.setReturnValue(method.getReturnType().getSimpleName());
                Class<?>[] parameterTypes = method.getParameterTypes();
                StringBuffer stringBuffer = new StringBuffer();
                for (Class<?> pac : parameterTypes) {
                    stringBuffer.append(pac.getSimpleName() + ",");
                }
                int lastIndexOf = stringBuffer.lastIndexOf(",");
                if (lastIndexOf != -1) {
                    stringBuffer.delete(lastIndexOf, lastIndexOf + 1);
                }
                mapping.setRequiredParam(stringBuffer.toString());
                mapping.setDescription(description);
                String url = MappingFinder.geturl(rm);
                if (!url.startsWith("/")) {
                    url = "/" + url;
                }
                if (!urlPrefix.isEmpty()) {
                    mapping.setMappingUrl(urlPrefix + url);
                } else {
                    mapping.setMappingUrl(url.substring(1));
                }
                maps.add(mapping);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String geturl(Annotation re) {
        if (re != null) {
            try {
                Method value = re.getClass().getMethod("value", new Class[0]);
                String[] ss = (String[])value.invoke((Object)re, new Object[0]);
                return ss[0];
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return "";
        }
        return "";
    }
}

