/*
 * Decompiled with CFR 0.152.
 */
package cn.takujo.takujoframework.common.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassUtil {
    public static List<Class<?>> getClassesByPackage(Package pkg) {
        return ClassUtil.findClasses(pkg.getName());
    }

    public static List<Class<?>> getClassesByPackageName(String packageName) {
        Package pac = Package.getPackage(packageName);
        if (pac != null) {
            return ClassUtil.findClasses(packageName);
        }
        return new ArrayList();
    }

    public static List<Class<?>> getInterfaceImplClasses(Class<?> c) {
        String packageName;
        List<Class<?>> allClass;
        ArrayList returnClassList = null;
        if (c.isInterface() && !(allClass = ClassUtil.findClasses(packageName = c.getPackage().getName())).isEmpty()) {
            returnClassList = new ArrayList();
            for (Class<?> cls : allClass) {
                if (!c.isAssignableFrom(cls) || c.equals(cls)) continue;
                returnClassList.add(cls);
            }
        }
        return returnClassList;
    }

    private static List<Class<?>> findClasses(String packageName) {
        ArrayList classes = new ArrayList();
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    ClassUtil.findClassesByFile(packageName, filePath, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                ClassUtil.findClassesByJar(url, packageDirName, packageName, classes);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    private static void findClassesByFile(String packageName, String packagePath, List<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                ClassUtil.findClassesByFile(packageName + "." + file.getName(), file.getAbsolutePath(), classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(Class.forName(packageName + '.' + className));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private static void findClassesByJar(URL url, String packageDirName, String packageName, List<Class<?>> classes) {
        try {
            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (!name.startsWith(packageDirName)) continue;
                int idx = name.lastIndexOf(47);
                if (idx != -1) {
                    packageName = name.substring(0, idx).replace('/', '.');
                }
                if (idx != -1 || !name.endsWith(".class") || entry.isDirectory()) continue;
                String className = name.substring(packageName.length() + 1, name.length() - 6);
                try {
                    classes.add(Class.forName(packageName + '.' + className));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

