/*
 * Decompiled with CFR 0.152.
 */
package cn.takujo.takujoframework.mybatis.sqlhelper.insert;

import cn.takujo.takujoframework.mybatis.sqlhelper.base.Form;
import cn.takujo.takujoframework.mybatis.sqlhelper.base.Rule;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class InsertRule<T extends Form>
implements Rule {
    private String table;
    private T form;
    private Class<? extends Form> cla;

    public InsertRule(String table, T form) {
        this.table = table;
        this.form = form;
        this.cla = form.getClass();
    }

    public String base() {
        return "INSERT INTO " + this.table + " ";
    }

    @Override
    public String generate() {
        return this.lengthNotEqualZero(this.lengthEqualZero());
    }

    @Override
    public String commit() {
        return this.base() + this.generate();
    }

    public static String[] value(String column, String property) {
        String[] s = new String[]{column, "#{" + property + "}"};
        return s;
    }

    public String values(String[] ... value) {
        int length = value.length;
        if (length == 0) {
            return this.lengthNotEqualZero(this.lengthEqualZero());
        }
        return this.lengthNotEqualZero(value);
    }

    private String lengthNotEqualZero(String[][] value) {
        int length = value.length;
        StringBuffer l = new StringBuffer("(");
        StringBuffer v = new StringBuffer("VALUES(");
        for (int i = 0; i < length; ++i) {
            Object o;
            String[] s = value[i];
            String s1 = s[0];
            String s2 = s[1];
            if (s1.equals("id") || s2.equals("id") || (o = this.fieldValueIsExist(s2)) == null) continue;
            l.append(s1 + ",");
            v.append(s2 + ",");
        }
        int lastIndexOf = l.lastIndexOf(",");
        int lastIndexOf2 = v.lastIndexOf(",");
        if (lastIndexOf != -1) {
            l.deleteCharAt(lastIndexOf);
        }
        if (lastIndexOf2 != -1) {
            v.deleteCharAt(lastIndexOf2);
        }
        l.append(")");
        v.append(")");
        return l.toString() + " " + v.toString();
    }

    private String[][] lengthEqualZero() {
        Field[] declaredFields;
        Class<?> cla = this.form.getClass();
        ArrayList<String[]> p = new ArrayList<String[]>();
        for (Field field : declaredFields = cla.getDeclaredFields()) {
            String name = field.getName();
            int modifiers = field.getModifiers();
            if (this.isSerializableField(modifiers) || name.equals("id")) continue;
            String[] ss = new String[2];
            ss[1] = "#{" + name + "}";
            char[] array = name.toCharArray();
            StringBuffer sb = new StringBuffer();
            for (char c : array) {
                if (Character.isUpperCase(c)) {
                    sb.append('_');
                    sb.append(Character.toLowerCase(c));
                    continue;
                }
                sb.append(c);
            }
            ss[0] = sb.toString();
            p.add(ss);
        }
        String[][] ss = new String[p.size()][];
        p.toArray((T[])ss);
        return ss;
    }

    @Override
    public Map<String, Object> toMap() {
        Field[] declaredFields;
        Class<?> cla = this.form.getClass();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("myRule", this);
        for (Field field : declaredFields = cla.getDeclaredFields()) {
            Object o;
            String name = field.getName();
            int modifiers = field.getModifiers();
            if (this.isSerializableField(modifiers) || name.equals("id") || (o = this.fieldGetMethodInvoke(name)) == null) continue;
            map.put(name, o);
        }
        return map;
    }

    private boolean isSerializableField(int modifiers) {
        return Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    private Object fieldGetMethodInvoke(String field) {
        try {
            Method method = this.cla.getMethod("get" + field.substring(0, 1).toUpperCase() + field.substring(1), new Class[0]);
            return method.invoke(this.form, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Object fieldValueIsExist(String field) {
        int indexOf = field.indexOf("{");
        int lastIndexOf = field.lastIndexOf("}");
        return this.fieldGetMethodInvoke(field.substring(indexOf + 1, lastIndexOf));
    }

    public String getTable() {
        return this.table;
    }
}

