package cn.takujo.takujoframework.mybatis.sqlhelper.base;

import cn.takujo.takujoframework.mybatis.sqlhelper.find.FindRule;

/**
 * 公共条件类，用于给FindRule、DeleteRule、UpdateRule附加条件
 * 
 * @author wzx
 *
 */
public abstract class Condition {

	/**
	 * 大于
	 * 
	 * @param column
	 *            数据库列名
	 * @param property
	 *            映射java对象属性名
	 * @return 一个条件
	 */
	public static String greaterThan(String column, String property) {
		return column + ">" + "#{" + property + "}";
	}

	/**
	 * 大于等于
	 * 
	 * @param column
	 *            数据库列名
	 * @param property
	 *            映射java对象属性名
	 * @return 一个条件
	 */
	public static String greaterOrEqual(String column, String property) {
		return column + ">=" + "#{" + property + "}";
	}

	/**
	 * 等于
	 * 
	 * @param column
	 *            数据库列名
	 * @param property
	 *            映射java对象属性名
	 * @return 一个条件
	 */
	public static String equal(String column, String property) {
		return column + "=" + "#{" + property + "}";
	}

	/**
	 * 小于
	 * 
	 * @param column
	 *            数据库列名
	 * @param property
	 *            映射java对象属性名
	 * @return 一个条件
	 */
	public static String lessThan(String column, String property) {
		return column + "<" + "#{" + property + "}";
	}

	/**
	 * 小于等于
	 * 
	 * @param column
	 *            数据库列名
	 * @param property
	 *            映射java对象属性名
	 * @return 一个条件
	 */
	public static String lessOrEqual(String column, String property) {
		return column + "<=" + "#{" + property + "}";
	}

	/**
	 * 相似(%content%)
	 * 
	 * @param column
	 *            数据库列名
	 * @param property
	 *            映射java对象属性名
	 * @return 一个条件
	 */
	public static String like(String column, String property) {
		return column + " LIKE " + "CONCAT('%',#{" + property + "},'%')";
	}

	/**
	 * 前置相似 %在前
	 * 
	 * @param column
	 *            数据库列名
	 * @param property
	 *            映射java对象属性名
	 * @return 一个条件
	 */
	public static String frontLike(String column, String property) {
		return column + " LIKE " + "CONCAT('%',#{" + property + "})";
	}

	/**
	 * 后置相似 %在后
	 * 
	 * @param column
	 *            数据库列名
	 * @param property
	 *            映射java对象属性名
	 * @return 一个条件
	 */
	public static String backLike(String column, String property) {
		return column + " LIKE " + "CONCAT(#{" + property + "},'%')";
	}

	/**
	 * in
	 * 
	 * @param column
	 *            数据库列名
	 * @param nesting
	 *            必须是nesting()的返回值
	 * @return 例 id IN (SELECT...)
	 */
	public static String in(String column, String nesting) {
		return column + " IN " + nesting;
	}

	/**
	 * 嵌套查询
	 * 
	 * @param find
	 *            子查询
	 * @return 例 (SELECT...)
	 */
	public static String nesting(FindRule<? extends Form> find) {
		return "(" + find.commit() + ") ";
	}

	/**
	 * 附上and符号
	 * 
	 * @return and符号
	 */
	public static String attachAndSign() {
		return " AND ";
	}

	/**
	 * 附上or符号
	 * 
	 * @return or符号
	 */
	public static String attachOrSign() {
		return " OR ";
	}

}
